% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvrnorm}
\alias{mvrnorm}
\title{Multivariate Normal distribution sampler}
\usage{
mvrnorm(n, mu, Sigma)
}
\arguments{
\item{n}{sample size}

\item{mu}{mean vector. Will set the dimension}

\item{Sigma}{a square covariance matrix, of same dimension as \code{mu}.
No sanity check is performed to validate that the matrix is p.s.d., so use at own risk}
}
\value{
an \code{n} sample from a multivariate Normal distribution
}
\description{
Sampler derived using the eigendecomposition of the covariance
matrix \code{Sigma}. The function uses the Armadillo random normal generator
}
\examples{
mvrnorm(n=10, mu=c(0,2), Sigma=diag(2))
}

