% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gpde}
\alias{gpde}
\title{Generalized Pareto distribution (expected shortfall parametrization)}
\arguments{
\item{par}{vector of length 2 containing \eqn{e_m} and \eqn{\xi}, respectively the expected shortfall at probability 1/(1-\eqn{\alpha}) and the shape parameter.}

\item{dat}{sample vector}

\item{m}{number of observations of interest for return levels. See \strong{Details}}

\item{tol}{numerical tolerance for the exponential model}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{nobs}{number of observations}

\item{V}{vector calculated by \code{gpde.Vfun}}
}
\description{
Likelihood, score function and information matrix,
approximate ancillary statistics and sample space derivative
for the generalized Pareto distribution parametrized in terms of expected shortfall.

The parameter \code{m} corresponds to \eqn{\zeta_u}/(1-\eqn{\alpha}), where \eqn{\zeta_u} is the rate of exceedance over the threshold
\code{u} and \eqn{\alpha} is the percentile of the expected shortfall.
Note that the actual parametrization is in terms of excess expected shortfall, meaning expected shortfall minus threshold.
}
\details{
The observed information matrix was calculated from the Hessian using symbolic calculus in Sage.
}
\section{Usage}{
 \preformatted{gpde.ll(par, dat, m, tol=1e-5)
gpde.ll.optim(par, dat, m, tol=1e-5)
gpde.score(par, dat, m)
gpde.infomat(par, dat, m, method = c('obs', 'exp'), nobs = length(dat))
gpde.Vfun(par, dat, m)
gpde.phi(par, dat, V, m)
gpde.dphi(par, dat, V, m)}
}

\section{Functions}{


\itemize{
\item{\code{gpde.ll}:} {log likelihood}
\item{\code{gpde.ll.optim}:} {negative log likelihood parametrized in terms of log expected
shortfall and shape in order to perform unconstrained optimization}
\item{\code{gpde.score}:} {score vector}
\item{\code{gpde.infomat}:} {observed information matrix for GPD parametrized in terms of rate of expected shortfall and shape}
\item{\code{gpde.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gpde.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gpde.dphi}:} {derivative matrix of the canonical parameter in the local exponential family approximation}
}
}

\author{
Leo Belzile
}
