% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro-package.R
\docType{package}
\name{metro-package}
\alias{metro}
\alias{metro-package}
\title{metro: A package for the Washington Metropolitan Area Transit Authority API}
\description{
The Metro Transparent Data Sets API provides developer access to JSON data
for the order and location of rail stations by line, train arrival
predictions for each station, service alerts, and elevator/escalator status.
This package has been developed to make calls to the API using dedicated
R functions with copied documentation and identical parameters/arguments. All
functions return one or more data frames for easy analysis.
}
\section{Endpoints}{

There are six endpoint categories returning JSON data.
\enumerate{
\item Bus Route and Stop Methods, starting with \verb{bus_*}:
\itemize{
\item Bus Position: \code{\link[=bus_position]{bus_position()}}
\item Path details: \code{\link[=bus_path]{bus_path()}}
\item Routes: \code{\link[=bus_routes]{bus_routes()}}
\item Schedule: \code{\link[=bus_schedule]{bus_schedule()}}
\item Schedule at stop: \code{\link[=bus_departs]{bus_departs()}}
\item Stop search: \code{\link[=bus_stops]{bus_stops()}}
}
\item Incidents, ending with \verb{*_incidents}:
\itemize{
\item Bus Incidents: \code{\link[=bus_incidents]{bus_incidents()}}
\item Elevator/Escalator Outages: \code{\link[=elevator_incidents]{elevator_incidents()}}
\item Rail Incidents: \code{\link[=rail_incidents]{rail_incidents()}}
}
\item Misc Methods
\itemize{
\item Validate API Key: \code{\link[=wmata_validate]{wmata_validate()}}
}
\item Rail Station Information, starting with \verb{rail_*}:
\itemize{
\item Lines: \code{\link[=rail_lines]{rail_lines()}}
\item Parking Information: Not yet covered.
\item Path Between Stations: \code{\link[=rail_path]{rail_path()}}
\item Station Entrances: \code{\link[=rail_entrance]{rail_entrance()}}
\item Station Information: \code{\link[=station_info]{station_info()}}
\item Station List: \code{\link[=rail_stations]{rail_stations()}}
\item Station Timings: \code{\link[=rail_times]{rail_times()}}
\item Station to Station Information: \code{\link[=rail_destination]{rail_destination()}}
}
\item Real-Time Predictions, starting with \verb{next_*}:
\itemize{
\item Next Buses: \code{\link[=next_bus]{next_bus()}}
\item Next Trains: \code{\link[=next_train]{next_train()}}
}
\item Train Positions:
\itemize{
\item Live Train Positions: \code{\link[=rail_positions]{rail_positions()}}
\item Standard Routes: \code{\link[=standard_routes]{standard_routes()}}
\item Track Circuits: \code{\link[=track_circuits]{track_circuits()}}
}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kiernann/metro}
  \item \url{https://kiernann.github.io/metro/}
  \item Report bugs at \url{https://github.com/kiernann/metro/issues}
}

}
\author{
\strong{Maintainer}: Kiernan Nicholls \email{kiernann@protonmail.com}

}
\keyword{internal}
