% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region.r
\name{mjs_annotate_region}
\alias{mjs_annotate_region}
\title{Region annotations for line charts [EXPERIMENTAL]}
\usage{
mjs_annotate_region(mjs, x_start = NULL, x_end = NULL, label = NULL,
  css_class = NULL)
}
\arguments{
\item{mjs}{metricsgraphics object}

\item{x_start}{start point on x axis for region annotation}

\item{x_end}{end point on x axis for region annotation}

\item{label}{text label for annotation (leave \code{NULL}) for no label}

\item{css_class}{CSS class to apply (see References link for more information)}
}
\value{
metricsgraphics object
}
\description{
This function uses the \href{https://github.com/senseyeio/mg-regions}{mg-regions}
plugin to enable region highlighting with an optional label.
}
\details{
This function is also experimental and relies on the plugin maintainer to
continue support for it. You should be well-versed in CSS to use this function
properly.
}
\examples{
data.frame(year=seq(1790, 1970, 10),
           uspop=as.numeric(uspop)) \%>\%
  mjs_plot(x=year, y=uspop, title="Population Chart") \%>\%
  mjs_line() \%>\%
  mjs_annotate_region(1850, 1900, "Bad stuff") \%>\%
  mjs_annotate_region(1810, 1830, "Stuff")

set.seed(1492)
stocks <- data.frame(
  time = as.Date('2009-01-01') + (365 * 0:9),
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4))

stocks \%>\%
  mjs_plot(x=time, y=X) \%>\%
  mjs_line() \%>\%
  mjs_axis_x(xax_format="date") \%>\%
  mjs_annotate_region("2013-01-01", "2016-01-01", "Crazy times")

## custom region color
stocks \%>\%
  mjs_plot(x=time, y=X) \%>\%
  mjs_line() \%>\%
  mjs_axis_x(xax_format="date") \%>\%
  mjs_add_css_rule("{{ID}} .blk { fill:black }") \%>\%
  mjs_annotate_region("2013-01-01", "2016-01-01", "Crazy times", "blk")
}
\references{
\url{https://github.com/senseyeio/mg-regions}
}

