% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRD.R
\name{MRD}
\alias{MRD}
\title{Calculate mean root distance}
\usage{
MRD(samp, tree, abundance.weighted)
}
\arguments{
\item{samp}{A picante-style community data matrix with sites as rows, and
species as columns.}

\item{tree}{An ape-style phylogeny.}

\item{abundance.weighted}{Whether to weight the calculation by the abundance of a given
species in a given plot.}
}
\value{
A vector of MRD values.
}
\description{
Given a picante-style community data matrix (sites are rows, species are columns), 
and a phylogeny, calculate the mean root distance of the set of taxa in each site.
}
\details{
Mean root distance (MRD) as originally formulated by Kerr & Currie (1999)
defined MRD as the mean number of nodes between a set
of taxa and the root. It is not clear to me whether the number of nodes includes
the tip itself. In other words, should a species connected directly to the
root of the tree be considered to be separated by zero or one nodes from the root? I
have chosen to define it as one, but am open to changing it. This definition emphasizes
that "one" speciation event has occurred along that branch since the origin of the
clade (all caveats about extinction and phylogenetic sampling aside). The
abundance-weighted form of this calculation takes a row-wise (plot-wise) weighted-mean
where the values are a species' node-distance to the root, and the
weights are a species' abundance in the input community data matrix. I ran a quick test
to see whether abundance-weighted MRD might be equal to IAC of Cadotte et al. (2010),
and it does not seem to be. Therefore its utility is unknown (as is that of
non-abundance weighted MRD).
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

results <- MRD(cdm, tree, abundance.weighted=FALSE)
}
\references{
Kerr, J. T. and D. J. Currie. 1999. The relative importance of evolutionary
and environmental controls on broad-scale patterns of species richness in North
America. Ecoscience 6:329-337.
}
