% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summaries.R
\name{summaries}
\alias{summaries}
\title{Return summary statistics from a data frame of randomized metric values}
\usage{
summaries(null.output, concat.by = "richness")
}
\arguments{
\item{null.output}{Data frame of randomized metric values such as an element from a
call to reduceRandomizations()}

\item{concat.by}{Whether to concatenate the randomizations by richness, plot or both}
}
\value{
Either a list of or a data frame of summarized metric scores, see details.
}
\description{
Summarizes observed metric scores. Returns the mean, standard deviation and
95\% confidence intervals of each plot or observed richness.
}
\details{
Given a data frame of metric values, summarizes either by plot or richness.
Outputs the mean, standard deviation and 95\% confidence intervals of each plot or
observed richness. If provided with concat.by="both", outputs a list of two data
frames, one for by richness and one for by plot. Otherwise, outputs a data frame.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

rawResults <- metricsNnulls(tree, cdm)

results <- reduceRandomizations(rawResults)

test <- summaries(results$frequency, concat.by="richness")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

