% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_meta}
\alias{write_meta}
\title{Write Metadata Tags to a File}
\usage{
write_meta(.meta, path = "meta.html", append = FALSE)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{path}{The file to write into, defaults to \code{"meta.html"}.}

\item{append}{logical. Only used if the argument \code{file} is the
    name of file (and not a connection or \code{"|cmd"}).
    If \code{TRUE} output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}.}
}
\value{
Returns \code{.meta} invisibly.
}
\description{
Write your metadata tags to an HTML file that can be manually included in
your page.
}
\examples{
meta_html_snippet <- tempfile("metathis_example", fileext = ".html")

meta() \%>\%
  meta_name("package" = "metathis") \%>\%
  write_meta(meta_html_snippet)

readLines(meta_html_snippet, warn = FALSE)

}
\seealso{
Other meta_actions: 
\code{\link{include_meta}()}
}
\concept{meta_actions}
