% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.copas.R
\name{print.summary.copas}
\alias{print.summary.copas}
\title{Print detailed results of Copas selection model}
\usage{
\method{print}{summary.copas}(
  x,
  backtransf = x$backtransf,
  legend = TRUE,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.copas}.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE} (default), results are printed as odds ratios rather than
log odds ratio, for example.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{...}{Additional arguments (ignored).}
}
\description{
Print method for objects of class \code{summary.copas}.


This function prints the following information:

Range of gamma0 values used (see \code{help(copas)});

Range of gamma1 values used (see \code{help(copas)});

Largest SE of all studies in meta-analysis;

Range of probability publishing trial with largest SE;

The next table gives details relating to the summary of the contour plot.
Specifically, it gives details from fitting a straight line to each
treatment-contour in the contour plot. Column 1 (headed level) shows the
treatment-contours; column 2 (nobs) shows the number of observations used by
the contour plot command within the \code{copas} function to plot this
contour line; column 3 (adj.r.square) shows the adjusted r-square from
fitting a straight line to this contour; columns 4 & 5 show the slope and
its standard error from fitting a straight line to this contour.

Next, the printout of \code{summary.copas} is shown.
}
\examples{
data(Fleiss1993bin, package = "meta")

# Perform meta analysis, effect measure is odds ratio (OR)
#
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data=Fleiss1993bin, sm="OR")

# Print summary of Copas analysis
#
summary(copas(m1), level=0.95)

}
\seealso{
\code{\link{copas}}, \code{\link{plot.copas}},
  \code{\link{summary.copas}}
}
\author{
James Carpenter \email{James.Carpenter@lshtm.ac.uk}, Guido
Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
