% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatter_panel}
\alias{scatter_panel}
\title{Panel Function for Metaplot Scatterplot}
\usage{
scatter_panel(x, y, groups, xref = metOption("xref_scatter_panel",
  scatter_panel_ref), yref = metOption("yref_scatter_panel",
  scatter_panel_ref), ref.col = metOption("ref.col_scatter_panel", "grey"),
  ref.lty = metOption("ref.lty_scatter_panel", "solid"),
  ref.lwd = metOption("ref.lwd_scatter_panel", 1),
  ref.alpha = metOption("ref.alpha_scatter_panel", 1),
  xref.col = metOption("xref.col_scatter_panel", NULL),
  xref.lty = metOption("xref.lty_scatter_panel", NULL),
  xref.lwd = metOption("xref_lwd_scatter_panel", NULL),
  xref.alpha = metOption("xref_alpha_scatter_panel", NULL),
  yref.col = metOption("yref_col_scatter_panel", NULL),
  yref.lty = metOption("yref_lty_scatter_panel", NULL),
  yref.lwd = metOption("yref_lwd_scatter_panel", NULL),
  yref.alpha = metOption("yref_alpha_scatter_panel", NULL),
  ysmooth = metOption("ysmooth_scatter_panel", FALSE),
  xsmooth = metOption("xsmooth_scatter_panel", FALSE),
  smooth.lty = metOption("smooth.lty_scatter_panel", "dashed"),
  smooth.lwd = metOption("smooth.lwd_scatter_panel", 1),
  smooth.alpha = metOption("smooth.alpha_scatter_panel", 1),
  fit = metOption("fit_scatter_panel", NULL),
  fit.lty = metOption("fit.lty_scatter_panel", "solid"),
  fit.lwd = metOption("fit.lwd_scatter_panel", 1),
  fit.alpha = metOption("fit.alpha_scatter_panel", 1),
  conf = metOption("conf_scatter_panel", FALSE),
  conf.alpha = metOption("conf.alpha_scatter_panel", 0.3),
  loc = metOption("loc_scatter_panel", 0),
  iso = metOption("iso_scatter_panel", FALSE),
  global = metOption("global_scatter_panel", FALSE),
  global.col = metOption("global.col_scatter_panel", "grey"),
  global.fill = metOption("global.fill_scatter_panel", "grey"),
  msg = metOption("msg_scatter_panel", "metastats"), type,
  verbose = metOption("verbose_scatter_panel", FALSE), ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{xref}{reference line from x axis; can be function(x, y, ...)}

\item{yref}{reference line from y axis; can be function(y, x, ...)}

\item{ref.col}{default shared by \code{xref.col} and \code{yref.col}}

\item{ref.lty}{default shared by \code{xref.lty} and \code{yref.lty}}

\item{ref.lwd}{default shared by \code{xref.lwd} and \code{yref.lwd}}

\item{ref.alpha}{default shared by \code{xref.alpha} and \code{yref.alpha}}

\item{xref.col}{x reference line color (recycled)}

\item{xref.lty}{x reference line type (recycled)}

\item{xref.lwd}{x reference line size (recycled)}

\item{xref.alpha}{x reference line alpha (recycled)}

\item{yref.col}{y reference line color (recycled)}

\item{yref.lty}{y reference line type (recycled)}

\item{yref.lwd}{y reference line size (recycled)}

\item{yref.alpha}{y reference line alpha (recycled)}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{smooth.lty}{smooth line type}

\item{smooth.lwd}{smooth line size}

\item{smooth.alpha}{smooth alpha}

\item{fit}{draw a linear fit of y ~ x; defaults to \code{as.logical(conf)}}

\item{fit.lty}{fit line type}

\item{fit.lwd}{fit line size}

\item{fit.alpha}{fit alpha}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval; may not make sense if xlog is TRUE}

\item{conf.alpha}{alpha transparency for confidence region}

\item{loc}{where to print statistics on a panel; suppressed for grouped plots}

\item{iso}{logical: use isometric axes with line of unity (auto-selected if NA); can be a (partial) list of aesthetics (col, lty, lwd, alpha)}

\item{global}{if TRUE, xsmooth, ysmooth, fit, and conf are applied to all data rather than groupwise}

\item{global.col}{color for global aesthetics}

\item{global.fill}{fill color for global aesthetics}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{type}{overridden by scatter_panel}

\item{verbose}{generate messages describing process}

\item{...}{passed to panel.superpose, panel.xyplot, panel.polygon, region, panel.text}
}
\description{
Default panel function for scatter_data_frame. Calls \code{\link[lattice]{panel.xyplot}}
and optionally plots linear fit, confidence region, reference lines, and statistics.
Note that, although global options are supported, typically these are unreachable
since the calling function supplies appropriate values.
}
\seealso{
\code{\link{metastats}}

\code{\link{scatter.data.frame}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{categorical_panel}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_diagonal}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_key}}, \code{\link{metaplot_ref}},
  \code{\link{panel.meta_densityplot}},
  \code{\link{panel_tile}}, \code{\link{scatter_panel_ref}}

Other scatter: \code{\link{metaplot_key}},
  \code{\link{scatter.data.frame}},
  \code{\link{scatter_data_frame}}, \code{\link{scatter}}
}
