% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{plan}
\alias{plan}
\title{Create a analysis plan from all combination of variables}
\usage{
plan(analysis, population, observation, parameter, mock = 1, ...)
}
\arguments{
\item{analysis}{A character value of analysis term name.
The term name is used as key to link information.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{observation}{A character value of observation term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{mock}{A numeric value of mock table number.}

\item{...}{Additional arguments.}
}
\value{
A data frame containing the analysis plan.
}
\description{
This function is a wrapper of \code{\link[base:expand.grid]{base::expand.grid()}}.
}
\examples{
# Example 1
# Create an analysis plan of AE summary
# with any AE, drug-related AE, and serious AE
plan(
  analysis = "ae_summary",
  population = "apat",
  observation = c("wk12", "wk24"),
  parameter = "any;rel;ser"
)

# Example 2
# Create an analysis plan of AE specific
# with any AE, drug-related AE, and serious AE
plan(
  analysis = "ae_specific",
  population = "apat",
  observation = c("wk12", "wk24"),
  parameter = c("any", "rel", "ser")
)
}
