% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabularize_eml.R
\name{tabularize_eml}
\alias{tabularize_eml}
\title{Get tabular metadata}
\usage{
tabularize_eml(eml, full = FALSE)
}
\arguments{
\item{eml}{An emld class object, the path to an EML (.xml) metadata file, or a raw EML object.}

\item{full}{(logical) Returns the most commonly used metadata fields by default.
If \code{full = TRUE} is specified, the full set of metadata fields are returned.}
}
\value{
(data.frame) A data frame of selected EML values.
}
\description{
This function takes a path to an EML (.xml) metadata file and returns a data frame.
}
\examples{
   eml <- system.file("extdata", "test_data", "SoilMois2012_2017__full_metadata.xml",
                  package = "metajam")
   tabularize_eml(eml)
}
