% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_pairedN.R
\name{random_pairedN}
\alias{random_pairedN}
\title{Random generation of paired sample sizes (N) for study outcomes.}
\usage{
random_pairedN(K, mean = 15, min = 3, correlation = 0.95)
}
\arguments{
\item{K}{Number of paired sample sizes to generate.}

\item{mean}{The lambda (dispersion parameter) of a Poisson distribution.  The
default is 15, which will generate sample sizes that on average will center
around N = 15.}

\item{min}{A non-negative integer that specifies the minimum sample size that
can be generated.  Default is N = 3.}

\item{correlation}{A correlation ranging from zero to one that specifies how
'similar' the paired sample sizes will be to one another.  Default is 0.95 
(i.e. the paired sample sizes will be highly correlated).}
}
\value{
A data table of paired random sample sizes (N).
}
\description{
Generates random paired sample sizes (N).  For example, sample sizes for a
   treatment group and samples sizes for a control group.  These paired N 
   are often correlated within studies.
}

