% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{n_supertaxa}
\alias{n_supertaxa}
\title{Get number of supertaxa}
\arguments{
\item{obj}{([taxonomy()] or [taxmap()])}
}
\value{
\code{numeric}
}
\description{
Get number of supertaxa for each taxon in an object of type
[taxonomy()] or [taxmap()].
\preformatted{
obj$n_supertaxa()
n_supertaxa(obj)}
}
\examples{
# Count number of supertaxa that contain each taxon
n_supertaxa(ex_taxmap)

# Filter taxa based on the number of supertaxa
#  (this command removes all root taxa)
filter_taxa(ex_taxmap, n_supertaxa > 0)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
