% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PLOTS.R
\name{es_from_plot_means}
\alias{es_from_plot_means}
\title{Converts the means and bounds of an error bar (generally extracted from a plot) into four effect measures (SMD, MD, OR, COR)}
\usage{
es_from_plot_means(
  n_exp,
  n_nexp,
  plot_mean_exp,
  plot_mean_nexp,
  plot_mean_sd_lo_exp,
  plot_mean_sd_lo_nexp,
  plot_mean_sd_up_exp,
  plot_mean_sd_up_nexp,
  plot_mean_se_lo_exp,
  plot_mean_se_lo_nexp,
  plot_mean_se_up_exp,
  plot_mean_se_up_nexp,
  plot_mean_ci_lo_exp,
  plot_mean_ci_lo_nexp,
  plot_mean_ci_up_exp,
  plot_mean_ci_up_nexp,
  smd_to_cor = "viechtbauer",
  reverse_plot_means
)
}
\arguments{
\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{plot_mean_exp}{mean of participants in the experimental/exposed group (extracted from a plot).}

\item{plot_mean_nexp}{mean of participants in the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_sd_lo_exp}{lower bound of an error bar depicting -1 SD from the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_sd_lo_nexp}{lower bound of an error bar depicting -1 SD from the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_sd_up_exp}{upper bound of an error bar depicting +1 SD from the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_sd_up_nexp}{upper bound of an error bar depicting +1 SD from the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_se_lo_exp}{lower bound of an error bar depicting -1 SE from the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_se_lo_nexp}{lower bound of an error bar depicting -1 SE from the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_se_up_exp}{upper bound of an error bar depicting +1 SE from the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_se_up_nexp}{upper bound of an error bar depicting +1 SE from the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_ci_lo_exp}{lower bound of an error bar depicting the 95\% CI of the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_ci_lo_nexp}{lower bound of an error bar depicting the 95\% CI of the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{plot_mean_ci_up_exp}{upper bound of an error bar depicting the 95\% CI of the mean of the experimental/exposed group (extracted from a plot).}

\item{plot_mean_ci_up_nexp}{upper bound of an error bar depicting the 95\% CI of the mean of the non-experimental/non-exposed group (extracted from a plot).}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_plot_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 21. From plot: means and dispersion (crude)'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Converts the means and bounds of an error bar (generally extracted from a plot) into four effect measures (SMD, MD, OR, COR)
}
\details{
This function uses the bounds of an error bar of a mean obtained from a plot into a standard deviation.
Then, a mean difference (MD), Cohen's d (D), and Hedges' g (G) are estimated.
Odds ratio (OR), risk ratio (RR) and correlation coefficients (R/Z) are converted from the Cohen's d value.

\strong{To convert the bound of an error bar into a standard deviation,}
this function always prioritizes information from the \code{plot_mean_sd_*} arguments,
then those from the \code{plot_mean_se_*} arguments,
then those from the \code{plot_mean_ci_*} arguments.
\enumerate{
\item If the bounds of the standard deviations are provided, the following formulas are used:
\deqn{mean\_sd\_lo\_exp = plot\_mean\_exp - plot\_mean\_sd\_lo\_exp}
\deqn{mean\_sd\_up\_exp = plot\_mean\_sd\_up\_exp - plot\_mean\_exp}
\deqn{mean\_sd\_exp = \frac{mean\_sd\_lo\_exp + mean\_sd\_up\_exp}{2}}
}

\deqn{mean\_sd\_lo\_nexp = plot\_mean\_nexp - plot\_mean\_sd\_lo\_nexp}
\deqn{mean\_sd\_up\_nexp = plot\_mean\_sd\_up\_nexp - plot\_mean\_nexp}
\deqn{mean\_sd\_nexp = \frac{mean\_sd\_lo\_nexp + mean\_sd\_up\_nexp}{2}}

Note that if only one bound (e.g., the upper bound) is provided, it will be the
only information used to estimate the standard deviation value.

Then, calculations of the \code{\link{es_from_means_sd}} are used.
\enumerate{
\item If the bounds of the standard errors are provided, the following formulas are used:
\deqn{mean\_se\_lo\_exp = plot\_mean\_exp - plot\_mean\_se\_lo\_exp}
\deqn{mean\_se\_up\_exp = plot\_mean\_se\_up\_exp - plot\_mean\_exp}
\deqn{mean\_se\_exp = \frac{mean\_se\_lo\_exp + mean\_se\_up\_exp}{2}}
}

\deqn{mean\_se\_lo\_nexp = plot\_mean\_nexp - plot\_mean\_se\_lo\_nexp}
\deqn{mean\_se\_up\_nexp = plot\_mean\_se\_up\_nexp - plot\_mean\_nexp}
\deqn{mean\_se\_nexp = \frac{mean\_se\_lo\_nexp + mean\_se\_up\_nexp}{2}}

Note that if only one bound (e.g., the upper bound) is provided, it will be the
only information used to estimate the standard error value.

Then, calculations of the \code{\link{es_from_means_se}()} are used.
\enumerate{
\item If the bounds of the 95\% confidence intervals are provided, the calculations
of the \code{\link{es_from_means_ci}} are used.
}
}
\examples{
es_from_plot_means(
  n_exp = 35, n_nexp = 35,
  plot_mean_exp = 89, plot_mean_nexp = 104,
  plot_mean_sd_lo_exp = 69, plot_mean_sd_lo_nexp = 83,
  plot_mean_sd_up_exp = 109, plot_mean_sd_up_nexp = 125
)
}
