% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.meta.R
\name{weights.meta}
\alias{weights.meta}
\title{Calculate absolute and percentage weights for meta-analysis}
\usage{
\method{weights}{meta}(
  object,
  common = object$common,
  random = object$random,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{meta}.}

\item{common}{A logical indicating whether absolute and
percentage weights from the common effect model should be
calculated.}

\item{random}{A logical indicating whether absolute and
percentage weights from the random effects model should be
calculated.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
A data frame with the following variables is returned:
\tabular{lll}{
\bold{Variable} \tab \bold{Definition} \tab \bold{Condition} \cr
w.common \tab absolute weights in common effect model \tab (if
  \code{common = TRUE}) \cr
p.common \tab percentage weights in common effect model \tab (if
  \code{common = TRUE}) \cr
w.random \tab absolute weights in random effects model \tab (if
  \code{random = TRUE}) \cr
p.random \tab percentage weights in random effects model \tab (if
  \code{random = TRUE})
}
}
\description{
This function returns a data frame containing information on
absolute and percentage weights of individual studies contributing
to common effect and random effects meta-analysis.
}
\examples{
data(Fleiss1993cont)
# Do meta-analysis (common effect and random effects model)
#
meta1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, studlab = paste(study, year), sm = "SMD")

# Print weights for common effect and random effects meta-analysis
#
weights(meta1)

# Do meta-analysis (only random effects model)
#
meta2 <- update(meta1, common = FALSE)

# Print weights for random effects meta-analysis
#
weights(meta2)

# Print weights for common effect and random effects meta-analysis
#
weights(meta2, common = TRUE)

}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
