% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_funs.R
\name{Anomaly}
\alias{Anomaly}
\title{Anomalies}
\usage{
Anomaly(x, baseline = seq_along(x), ...)
}
\arguments{
\item{x}{numeric vector}

\item{baseline}{logical or numerical vector used for subsetting x before
computing the mean}

\item{...}{other arguments passed to \code{\link{mean}} such as \code{na.rm}}
}
\value{
A numeric vector of the same length as x with each value's distance to the
mean.
}
\description{
Saves keystrokes for computing anomalies.
}
\examples{
# Zonal temperature anomaly
library(data.table)
temperature[, .(lon = lon, air.z = Anomaly(air)), by = .(lat, lev)]

}
\seealso{
Other utilities: 
\code{\link{JumpBy}()},
\code{\link{Mag}()},
\code{\link{Percentile}()},
\code{\link{logic}}
}
\concept{utilities}
