% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_contour2.r, R/stat_contour2.r
\docType{data}
\name{geom_contour2}
\alias{geom_contour2}
\alias{GeomContour2}
\alias{stat_contour2}
\alias{StatContour2}
\title{2d contours of a 3d surface}
\usage{
geom_contour2(mapping = NULL, data = NULL, stat = "contour2",
  position = "identity", ..., lineend = "butt", linejoin = "round",
  linemitre = 1, breaks = MakeBreaks(), bins = NULL,
  binwidth = NULL, na.rm = FALSE, na.fill = FALSE,
  show.legend = NA, inherit.aes = TRUE)

stat_contour2(mapping = NULL, data = NULL, geom = "contour2",
  position = "identity", ..., breaks = MakeBreaks(), bins = NULL,
  binwidth = NULL, na.rm = FALSE, na.fill = FALSE,
  show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{breaks}{One of:
\itemize{
\item A numeric vector of breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output
}}

\item{bins}{Number of evenly spaced breaks.}

\item{binwidth}{Distance between breaks.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{na.fill}{How to fill missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{geom}{The geometric object to use display the data}
}
\description{
A copy of \link[ggplot2:geom_contour]{ggplot2::geom_contour} that accepts a function as the \code{breaks}
argument and makes gaps for labels and computes breaks globally instead of
per panel.
}
\section{Aesthetics}{

\code{geom_contour2} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{size}
\item \code{weight}
}
}

\section{Computed variables}{

\describe{
\item{level}{height of contour}
}
}

\examples{
library(ggplot2)
ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, color = ..level..),
                  breaks = AnchorBreaks(130, binwidth = 11))

}
\seealso{
Other ggplot2 helpers: \code{\link{DivideTimeseries}},
  \code{\link{MakeBreaks}}, \code{\link{WrapCircular}},
  \code{\link{geom_arrow}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{reverselog_trans}},
  \code{\link{scale_divergent}},
  \code{\link{scale_longitude}}, \code{\link{stat_na}},
  \code{\link{stat_subset}}

Other ggplot2 helpers: \code{\link{DivideTimeseries}},
  \code{\link{MakeBreaks}}, \code{\link{WrapCircular}},
  \code{\link{geom_arrow}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{reverselog_trans}},
  \code{\link{scale_divergent}},
  \code{\link{scale_longitude}}, \code{\link{stat_na}},
  \code{\link{stat_subset}}
}
\concept{ggplot2 helpers}
\keyword{datasets}
