% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_tendency.R
\name{coerce_tendency}
\alias{coerce_tendency}
\alias{median.mdate}
\alias{vmedian}
\alias{vmedian.mdate}
\alias{mean.mdate}
\alias{vmean}
\alias{vmean.mdate}
\alias{modal}
\alias{modal.mdate}
\alias{vmodal}
\alias{vmodal.mdate}
\alias{random}
\alias{random.mdate}
\alias{vrandom}
\alias{vrandom.mdate}
\title{Resolves messy dates into a central tendency}
\usage{
\method{median}{mdate}(..., na.rm = TRUE)

vmedian(..., na.rm = TRUE)

\method{vmedian}{mdate}(..., na.rm = TRUE)

\method{mean}{mdate}(..., trim = 0, na.rm = TRUE)

vmean(..., na.rm = TRUE)

\method{vmean}{mdate}(..., trim = 0, na.rm = TRUE)

modal(..., na.rm = TRUE)

\method{modal}{mdate}(..., na.rm = TRUE)

vmodal(..., na.rm = TRUE)

\method{vmodal}{mdate}(..., na.rm = TRUE)

random(..., na.rm = TRUE)

\method{random}{mdate}(..., na.rm = TRUE)

vrandom(..., na.rm = TRUE)

\method{vrandom}{mdate}(..., na.rm = TRUE)
}
\arguments{
\item{...}{a mdate object}

\item{na.rm}{Should NAs be removed? True by default.}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed
from each end of x before the mean is computed.
Values of trim outside that range are taken as the nearest endpoint.}
}
\description{
These functions resolve messydates by their central tendency.
While the functions \code{mean()}, \code{median()}, and \code{modal()} summarise the
vector to a single value, \verb{v*()} versions return a vector of the same length.
}
\examples{
d <- as_messydate(c("2008-03-25", "?2012-02-27", "2001-01?", "2001~",
  "2001-01-01..2001-02-02", "{2001-01-01,2001-02-02}",
  "{2001-01,2001-02-02}", "2008-XX-31", "-0050-01-01"))
d
median(d)
vmedian(d)
mean(d)
vmean(d)
modal(d)
vmodal(d)
random(d)
vrandom(d)
}
