% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grplot.R
\name{network_plot}
\alias{network_plot}
\title{Plot graph}
\usage{
network_plot(adj, names = NULL,
  layout = igraph::layout.fruchterman.reingold, nod_col = "#E0EED4",
  nod_cex = 3, nod_shadow = T, edg_col = "grey25", edg_lwd = 1.5,
  lab_col = "black", lab_cex = 1, lab_lwd = 1, lab_lcol = "grey25",
  lab_grid_size = 48, lab_padding = c(3, 3))
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix. Can also be an
object of class \code{"igraph"} or an edge list, i.e., a two-column
\code{matrix} or \code{data.frame} containing specifying the edges start
and end points.}

\item{names}{optional character vector specifying the node names. Must be of
appropriate length.}

\item{layout}{layout function from the \code{igraph} package. Default is
\link[igraph]{layout.fruchterman.reingold}.}

\item{nod_col}{character vector of length 1 or length |V| specifying the
node colors.}

\item{nod_cex}{numeric speciying the size of the node circles.}

\item{nod_shadow}{logical specifiying whether nodes should have shadows. Node
shodow color is created from darkening \code{node_col}.}

\item{edg_col}{character vector of length 1 of length |E| specifying the edge
line colors.}

\item{edg_lwd}{numeric vector of length 1 of length |E| specifying the edge
line widths.}

\item{lab_col}{character vector of length 1 of length |V| specifying the
text label colors.}

\item{lab_cex}{numeric vector of length 1 of length |V| specifying the
text label sizes.}

\item{lab_lwd}{numeric vector of length 1 of length |V| specifying the
width of the lines connecting the text label to the nodes.}

\item{lab_lcol}{character vector of length 1 of length |E| specifying
specifying the color of the lines connecting the text label to the nodes.}

\item{lab_grid_size}{integer specifying the grid size used to place the node
labels. Canvas is split in \code{lab_grid_size} and labels are placed into
cells closest to the associated node.}

\item{lab_padding}{numeric vector of length 2 specifying the spacing among
labels and between labels and nodes on the x and y dimension.}
}
\value{
nothing. A plot is created in \link{dev.cur}.
}
\description{
Custom graph plot using \code{igraph}'s layout functions.
}
\examples{

\dontrun{
# get fluency data
data(animal_fluency)

# edge list of fluency graph
edge_list = threshold_graph(animal_fluency[1:20])

# get adjacency matrix
adj = edg_to_adj(edge_list)

# plot
network_plot(adj)
}

}
