% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grplot.R
\name{neighborhood_plot}
\alias{neighborhood_plot}
\title{Neighborhood plot}
\usage{
neighborhood_plot(adj, names = NULL, node, k = 2,
  nod_col = "#E0EED4", nod_shading = TRUE, ...)
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix. Can also be an
object of class \code{"igraph"} or an edge list, i.e., a two-column
\code{matrix} or \code{data.frame} containing specifying the edges start
and end points.}

\item{names}{optional character vector specifiying the node names.}

\item{node}{integer specifying the row index (within the adjacency
matrix) of the node whose the neighborhood should be plotted.
Alternatively the node name.}

\item{k}{integer specifying the size of the neighborhood. Specifically,
the plot will contain all nodes that are \code{k} or fewer steps away
from \code{v}.}

\item{nod_col}{character vector of length 1 specifying the node colors.}

\item{nod_shading}{logical specifying whether the node colors should be shaded
as a function of the distance to \code{node}.}

\item{\dots}{arguments to be passed to \link{network_plot}.}
}
\value{
nothing. A plot is created in \link{dev.cur}.
}
\description{
Plot k-Neighborhood of given node containing all nodes with distances
larger than k from given node.
}
\examples{

\dontrun{
# get fluency data
data(animal_fluency)

# edge list of fluency graph
edge_list = threshold_graph(animal_fluency[1:40])

# get adjacency matrix
adj = edg_to_adj(edge_list)

# plot
neighborhood_plot(adj, node = 'dog', k = 2)
}

}
