% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{l_comp}
\alias{l_comp}
\title{Retrieve largest component}
\usage{
l_comp(adj, weights = NULL, mode = "undirected", igraph = FALSE)
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix.}

\item{weights}{numeric vector of edge weights. Optional.}

\item{mode}{character, either \code{"directed"} or \code{"undirected"},
specifying whether the network should be interepeted as directed
or undirected. Defaults to \code{"undirected"}.}

\item{igraph}{logical specifying whether the output should be of class
\code{"igraph"}.}
}
\value{
A list containing the, now, named adjacency matrix and a numeric value
indicating the size of the largest component relative to
to the entire graph.
}
\description{
Retrieves the largest component. In case of equally sized
components the first is component is retrieved.
}
\examples{

# get fluency data
data(animal_fluency)

# edge list of fluency graph
edge_list = threshold_graph(animal_fluency[1:10])

# get adjacency matrix
adj = edg_to_adj(edge_list)

# get largest component
l_comp(adj)

}
