% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_node_distance.R
\name{edge_node_distance}
\alias{edge_node_distance}
\title{Perform the distance distribution of paired nodes in edges across networks.}
\description{
This class is a wrapper for a series of analysis on the distance values 
of paired nodes in edges across networks, including distance matrix conversion, the differential test and the visualization.
}
\examples{

## ------------------------------------------------
## Method `edge_node_distance$new`
## ------------------------------------------------

\donttest{
data(soil_amp_network)
data(soil_amp)
# filter useless features to speed up the calculation
node_names <- unique(unlist(lapply(soil_amp_network, function(x){colnames(x$data_abund)})))
filter_soil_amp <- microeco::clone(soil_amp)
filter_soil_amp$otu_table <- filter_soil_amp$otu_table[node_names, ]
filter_soil_amp$tidy_dataset()
# obtain phylogenetic distance matrix
phylogenetic_distance <- as.matrix(cophenetic(filter_soil_amp$phylo_tree))
# choose the positive labels
t1 <- edge_node_distance$new(network_list = soil_amp_network, 
	 dis_matrix = phylogenetic_distance, label = "+")
}

## ------------------------------------------------
## Method `edge_node_distance$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(method = "wilcox")
}

## ------------------------------------------------
## Method `edge_node_distance$plot`
## ------------------------------------------------

\donttest{
t1$plot(boxplot_add = "none", add_sig = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-edge_node_distance-new}{\code{edge_node_distance$new()}}
\item \href{#method-edge_node_distance-cal_diff}{\code{edge_node_distance$cal_diff()}}
\item \href{#method-edge_node_distance-plot}{\code{edge_node_distance$plot()}}
\item \href{#method-edge_node_distance-clone}{\code{edge_node_distance$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edge_node_distance-new"></a>}}
\if{latex}{\out{\hypertarget{method-edge_node_distance-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{edge_node_distance$new(
  network_list,
  dis_matrix = NULL,
  label = "+",
  with_module = FALSE,
  module_thres = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_list}}{a list with multiple networks; all the networks should be \code{trans_network} object 
created from \code{\link{trans_network}} class of microeco package.}

\item{\code{dis_matrix}}{default NULL; the distance matrix of nodes, used for the value extraction; 
must be a symmetrical matrix with both colnames and rownames (i.e. feature names).}

\item{\code{label}}{default "+"; "+" or "-" or \code{c("+", "-")}; the edge label used for the selection of edges.}

\item{\code{with_module}}{default FALSE; whether show the module classification of nodes in the result.}

\item{\code{module_thres}}{default 2; the threshold of the nodes number of modules remained when \code{with_module = TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_table}, stored in the object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(soil_amp_network)
data(soil_amp)
# filter useless features to speed up the calculation
node_names <- unique(unlist(lapply(soil_amp_network, function(x){colnames(x$data_abund)})))
filter_soil_amp <- microeco::clone(soil_amp)
filter_soil_amp$otu_table <- filter_soil_amp$otu_table[node_names, ]
filter_soil_amp$tidy_dataset()
# obtain phylogenetic distance matrix
phylogenetic_distance <- as.matrix(cophenetic(filter_soil_amp$phylo_tree))
# choose the positive labels
t1 <- edge_node_distance$new(network_list = soil_amp_network, 
	 dis_matrix = phylogenetic_distance, label = "+")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edge_node_distance-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-edge_node_distance-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Differential test across networks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{edge_node_distance$cal_diff(
  method = c("anova", "KW", "KW_dunn", "wilcox", "t.test")[1],
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "anova"; see the following available options:
\describe{
  \item{\strong{'anova'}}{Duncan's multiple range test for anova}
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see \code{dunnTest} function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
}}

\item{\code{...}}{parameters passed to \code{cal_diff} function of \code{trans_alpha} class of \code{microeco} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_diff} in object. See the Return of \code{cal_diff} function in \code{trans_alpha} class of \code{microeco} package.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(method = "wilcox")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edge_node_distance-plot"></a>}}
\if{latex}{\out{\hypertarget{method-edge_node_distance-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the distance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{edge_node_distance$plot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters pass to \code{plot_alpha} function of \code{trans_alpha} class of \code{microeco} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot(boxplot_add = "none", add_sig = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edge_node_distance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-edge_node_distance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{edge_node_distance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
