% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ror.R
\name{ror}
\alias{ror}
\alias{ror.mds_ts}
\alias{ror.default}
\title{Reporting Odds Ratio}
\usage{
ror(df, ...)

\method{ror}{mds_ts}(df, ts_event = c(Count = "nA"), analysis_of = NA, ...)

\method{ror}{default}(
  df,
  analysis_of = NA,
  eval_period = 1,
  null_ratio = 1,
  alpha = 0.05,
  cont_adj = 0,
  ...
)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{nA}{Cell A count (class \code{numeric}) of the 2x2 table:
  device/event of interest.}
  \item{nB}{Cell B count (class \code{numeric}) of the 2x2 table:
  device/non-event of interest.}
  \item{nC}{Cell C count (class \code{numeric}) of the 2x2 table:
  non-device/event of interest.}
  \item{nD}{Cell D count (class \code{numeric}) of the 2x2 table:
  non-device/non-event of interest.}
}}

\item{...}{Further arguments passed onto \code{ror} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count (cell A in the 2x2
contingency table). In most cases, the default is the appropriate setting.
See details for alternative options.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Count of bone cement leakages"}}

\item{eval_period}{Required positive integer indicating the number of unique
times counting in reverse chronological order to sum over to create the 2x2
contingency table.

Default: \code{1} considers only the most recent time in \code{df}.

Example: \code{12} sums over the last 12 time periods to create the 2x2
contingency table.}

\item{null_ratio}{Numeric ROR value representing the null hypothesis, used
with \code{alpha} to establish the signal status and the p-value.

Default: \code{1} indicates a null hypothesis of ROR=1 and tests if the
actual ROR is greater than 1.}

\item{alpha}{Numeric value representing the statistical alpha used to
establish the signal status.

Default: \code{0.05} corresponds to the standard alpha value of 5\%.}

\item{cont_adj}{Numeric value 0 or greater representing the continuity
adjustment to be added to each cell of the 2x2 contingency table. A value
greater than 0 allows for contingency tables with 0 cells to run the
algorithm. A typical non-zero value is 0.5.

Default: \code{0} adds zero to each cell, thus an unadjusted table. If any
cell of the 2x2 is 0, the algorithm will not run.}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the set
  confidence bounds, \code{p} for the p-value, \code{signal} status, and
  \code{signal_threshold}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using the reporting odds ratio (ROR). From
the family of disproportionality analyses (DPA) used to generate signals of
disproportionate reporting (SDRs).
}
\details{
For parameter \code{ts_event}, in the uncommon case where the
device-event count (Cell A) variable is not \code{"nA"}, the name of the
variable may be specified here. Note that the remaining 3 cells of the 2x2
contingency table (Cells B, C, D) must be the variables \code{"nB"},
\code{"nC"}, and \code{"nD"} respectively in \code{df}. A named character
vector may be used where the name is the English description of what was
analyzed. Note that if the parameter \code{analysis_of} is specified, it will
override this name. Example: \code{ts_event=c("Count of Bone Cement
Leakages"="event_count")}
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: ROR on mds_ts data

\item \code{default}: ROR on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:25),
                   nA=as.integer(stats::rnorm(25, 25, 5)),
                   nB=as.integer(stats::rnorm(25, 50, 5)),
                   nC=as.integer(stats::rnorm(25, 100, 25)),
                   nD=as.integer(stats::rnorm(25, 200, 25)))
a1 <- ror(data)
# Example using an mds_ts object
a2 <- ror(mds_ts[[3]])

}
\references{
Stricker BH, Tijssen JG. Serum sickness-like reactions to cefaclor. J Clin Epidemiol. 1992;45(10):1177-84.

Bohm R, Klein H.-J. (v2018-10-16). Primer on Disportionality Analysis. OpenVigil http://openvigil.sourcefourge.net/doc/DPA.pdf
}
