% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/referenceInterval.R
\name{robustRI}
\alias{robustRI}
\title{Robust Method in Calculation of Reference Interval}
\usage{
robustRI(x, ind = 1:length(x), conf.level = 0.95, tol = 1e-06)
}
\arguments{
\item{x}{(\code{numeric})\cr numeric measurements from target population.}

\item{ind}{(\code{integer})\cr integer vector for boot process, default is all elements
in \code{x}.}

\item{conf.level}{(\code{numeric})\cr significance level for the internal t statistic.}

\item{tol}{(\code{numeric})\cr tolerance for when the iterative process can be stopped.}
}
\value{
a vector of robust reference interval
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This robust method is used to calculate the reference interval on small sample
size (below to 120 observations).
}
\examples{
# This example data is taken from EP28A3 Appendix B. to ensure the result is in accordance.
x <- c(8.9, 9.2, rep(9.4, 2), rep(9.5, 3), rep(9.6, 4), rep(9.7, 5), 9.8, rep(9.9, 2), 10.2)
robustRI(x)
}
\references{
This robust algorithm is referring to CLSI document EP28A3.
}
