% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpfit_methods.R
\docType{class}
\name{mcpfit-class}
\alias{mcpfit-class}
\alias{mcpfit}
\title{Class \code{mcpfit} of models fitted with the \pkg{mcp} package}
\description{
Models fitted with the \code{\link[mcp:mcp]{mcp}} function are represented as
an \code{mcpfit} object which contains the user input (model, data, family),
derived model characteristics (prior, parameter names, and jags code), and
the fit (prior and/or posterior mcmc samples).
}
\details{
See \code{methods(class = "mcpfit")} for an overview of available methods.

User-provided information (see \code{\link{mcp}} for more details):
}
\section{Slots}{

\describe{
\item{\code{model}}{A list of formulas, making up the model.
Provided by user. See \code{\link{mcp}} for more details.}

\item{\code{data}}{A data frame.
Provided by user. See \code{\link{mcp}} for more details.}

\item{\code{family}}{An \code{mcpfamily} object.
Provided by user. See \code{\link{mcp}} for more details.}

\item{\code{prior}}{A named list.
Provided by user. See \code{\link{mcp}} for more details.}

\item{\code{mcmc_post}}{An \code{\link[coda]{mcmc.list}} object with posterior samples.}

\item{\code{mcmc_prior}}{An \code{\link[coda]{mcmc.list}} object with prior samples.}

\item{\code{mcmc_loglik}}{An \code{\link[coda]{mcmc.list}} object with samples of log-likelihood.}

\item{\code{pars}}{A list of character vectors of model parameter names.}

\item{\code{jags_code}}{A string with jags code. Use \code{cat(fit$jags_code)} to show it.}

\item{\code{simulate}}{A method to simulate and predict data.}

\item{\code{.other}}{Information that is used internally by mcp.}
}}

