% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_abundance_to_presence.R
\name{convert_abundance_to_presence}
\alias{convert_abundance_to_presence}
\title{Convert Abundance Values to Presence/Absence Indicators}
\usage{
convert_abundance_to_presence(module_abundance)
}
\arguments{
\item{module_abundance}{A data frame containing KO abundance data, must include:
- Rows named by Orthology_Entry (KO identifiers)
- Numeric columns representing sample abundances
- An Orthology_Entry column}
}
\value{
A data frame with:
- Binary values (1 = present, 0 = absent) for each sample
- Original row names preserved in Orthology_Entry column
- Same dimensions as input (excluding the Orthology_Entry column)
}
\description{
Transforms a numeric abundance matrix into a binary presence/absence matrix,
where 1 indicates presence (abundance > 0) and 0 indicates absence.
Preserves row names as Orthology_Entry column in the output.
}
