% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sds.R
\name{sds.mcgf}
\alias{sds.mcgf}
\alias{sds.mcgf_rs}
\alias{sds<-}
\title{Extract, calculate, or assign standard deviations for an \code{mcgf} or
\code{mcgf_rs} object.}
\usage{
\method{sds}{mcgf}(x, ...)

\method{sds}{mcgf_rs}(x, replace = FALSE, ...)

sds(x) <- value
}
\arguments{
\item{x}{An \code{mcgf} or \code{mcgf_rs} object.}

\item{...}{Additional parameters or attributes. Not in use.}

\item{replace}{Logical; if TRUE, \code{sds} are recalculated.}

\item{value}{A vector (or list of vectors) of standard deviations for all
stations (under each regime and combined).}
}
\value{
\code{\link[=sds]{sds()}} returns empirical (regime-switching) standard deviations.
}
\description{
Extract, calculate, or assign standard deviations for an \code{mcgf} or
\code{mcgf_rs} object.
}
\details{
For \code{mcgf} objects, \code{\link[=sds]{sds()}} extracts or computes the empirical standard
deviations. The output is a vector of sds.

For \code{mcgf_rs} objects, \code{\link[=sds]{sds()}} extracts or computes the regime-switching
empirical standard deviations. The output is a list of vectors of sds. Each
element in the list corresponds to the sds for a regime.

\code{\link{sds<-}} assigns \code{sds} to \code{x}. Use \code{\link[=add_ccfs]{add_ccfs()}} to add both \code{ccfs} and
\code{sds} to \code{x}.
}
\examples{
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
sds(sim1_mcgf)

data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
sds(sim2_mcgf)
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
sim1_sds <- sds(sim1_mcgf)
sds(sim1_mcgf) <- sim1_sds

data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
sim2_sds <- sds(sim2_mcgf)
sds(sim2_mcgf) <- sim2_sds
}
