% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_sep.R
\name{.cor_sep}
\alias{.cor_sep}
\title{Calculate correlation for separable model}
\usage{
.cor_sep(spatial, temporal, par_s, par_t)
}
\arguments{
\item{spatial}{Pure spatial model, \code{exp} or \code{cauchy} for now.}

\item{temporal}{Pure temporal model, \code{exp} or \code{cauchy} for now.}

\item{par_s}{Parameters for the pure spatial model. Nugget effect supported.}

\item{par_t}{Parameters for the pure temporal model.}
}
\value{
Correlations for separable model.
}
\description{
Calculate correlation for separable model
}
\details{
The separable model is the product of a pure temporal model, \eqn{C_T(u)},
and a pure spatial model, \eqn{C_S(\mathbf{h})}. It is of the form
\deqn{C(\mathbf{h}, u)=C_{T}(u)
\left[(1-\text{nugget})C_{S}(\mathbf{h})+\text{nugget}
\delta_{\mathbf{h}=0}\right],}
where \eqn{\delta_{x=0}} is 1 when \eqn{x=0} and 0 otherwise. Here
\eqn{\mathbf{h}\in\mathbb{R}^2} and \eqn{u\in\mathbb{R}}. Now only
exponential and Cauchy correlation models are available.
}
\references{
Gneiting, T. (2002). Nonseparable, Stationary Covariance Functions for
Space–Time Data, Journal of the American Statistical Association, 97:458,
590-600.
}
\keyword{internal}
