% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{mcen_bin_workhorse}
\alias{mcen_bin_workhorse}
\title{Calculates cluster assignment and coefficient estimates for a binomial mcen.}
\usage{
mcen_bin_workhorse(beta, delta = NULL, y, x, family = "mbinomial",
  ky = NULL, gamma_y = 1, eps = 1e-05, clusterMethod = "kmeans",
  clusterIterations = 100, clusterStartNum = 30, cluster_y = NULL,
  max_iter = 10)
}
\arguments{
\item{beta}{Initial estimate of coefficients.}

\item{delta}{Tuning parameter for L1 penalty.}

\item{y}{Matrix of responses.}

\item{x}{Matrix of predictors.}

\item{family}{type of likelihood used two options "mgaussian" or "mbinomial"}

\item{ky}{Number of clusters used for grouping response variables.}

\item{gamma_y}{Tuning parameter for the penalty between fitted values for responses in the same group.}

\item{eps}{Convergence criteria}

\item{clusterMethod}{Which clustering method was used, currently support kmeans or kmeanspp}

\item{clusterIterations}{Number of iterations for cluster convergence}

\item{clusterStartNum}{Number of random starting points for clustering}

\item{cluster_y}{An a priori definition of clusters. If clusters are provided they will remain fixed and are not estimated. Objective function is then convex.}

\item{max_iter}{The maximum number of iterations for estimating the coefficients}
}
\description{
Calculates cluster assignment and coefficient estimates for a binomial mcen.
}
\author{
Brad Price <brad.price@mail.wvu.edu>
}
