% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotate_from_matrix}
\alias{annotate_from_matrix}
\alias{annotate_row_from_apply}
\alias{annotate_column_from_apply}
\title{Apply functions to a single matrix of a matrixset and store results as annotation}
\usage{
annotate_row_from_apply(
  .ms,
  .matrix,
  ...,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE
)

annotate_column_from_apply(
  .ms,
  .matrix,
  ...,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE
)
}
\arguments{
\item{.ms}{\code{matrixset} object}

\item{.matrix}{a tidyselect matrix name: matrix name as a bare name or a
character.}

\item{...}{expressions, separated by commas. They can be specified in one of
the following way:
\itemize{
\item a function name, e.g., \code{mean}.
\item a function call, where you can use \code{.m} to represent the current matrix
(for \code{apply_matrix}), \code{.i} to represent the current row (for \code{apply_row})
and \code{.j} for the current column (\code{apply_column}). Bare names of object
traits can be used as well. For instance, \code{lm(.i ~ program)}.

The pronouns are also available for the multivariate version, under
certain circumstances, but they have a different meaning. See the
"Multivariate" section for more details.
\item a formula expression. The pronouns \code{.m}, \code{.i} and \code{.j} can be used as
well. See examples to see the usefulness of this.
}

The expressions can be named; these names will be used to provide names to
the results.}

\item{names_prefix, names_sep, names_glue, names_sort, names_vary, names_expand}{See
the same arguments of \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}}
}
\value{
A \code{matrixset} with updated meta info.
}
\description{
This is in essence \code{\link[=apply_row_dfw]{apply_row_dfw()}}/\code{\link[=apply_column_dfw]{apply_column_dfw()}}, but with the
results saved as new annotations. As such, the usage is almost identical to
these functions, except that only a single matrix can be used, and must be
specified (matrix specification differs also slightly).
}
\details{
A conscious choice was made to provide this functionality only for
\verb{apply_*_dfw()}, as this is the only version for which the output dimension
is guaranteed to respect the \code{matrixset} paradigm.

On that note, see the section 'Grouped \code{matrixset}'.
}
\section{Grouped \code{matrixset}}{

In the context of grouping, the \verb{apply_*_dfw()} functions stack the results
for each group value.

In the case of \verb{annotate_*_from_matrix()}, a \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}} is
further applied to ensure compatibility of the dimension.

The \code{pivot_wider()} arguments \code{names_prefix}, \code{names_sep}, \code{names_glue},
\code{names_sort}, \code{names_vary } and \code{names_expand} can help you control the final
annotation trait names.
}

\examples{
# This is the same example as in annotate_row(), but with the "proper" way
# of doing it
ms <- annotate_row_from_apply(student_results, "failure", mn = mean)

}
\seealso{
\code{\link[=annotate_row]{annotate_row()}}/\code{\link[=annotate_column]{annotate_column()}}.
}
