library("matrixStats")

rowCumprods_R <- function(x) {
  suppressWarnings({
    t(apply(x, MARGIN=1L, FUN=cumprod))
  })
}

colCumprods_R <- function(x) {
  suppressWarnings({
    apply(x, MARGIN=2L, FUN=cumprod)
  })
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# With and without some NAs
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
for (addNA in c(FALSE, TRUE)) {
  cat("addNA=", addNA, "\n", sep="")

  x <- matrix(1:100, nrow=20, ncol=5)
  if (addNA) {
    x[13:17,c(2,4)] <- NA_real_
  }

  # Row/column ranges
    r0 <- rowCumprods_R(x)
    r1 <- rowCumprods(x)
    r2 <- t(colCumprods(t(x)))
    stopifnot(all.equal(r1, r2))
    stopifnot(all.equal(r1, r0))
    stopifnot(all.equal(r2, r0))
} # for (addNA ...)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# All NAs
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
x <- matrix(NA_real_, nrow=20, ncol=5)
  r0 <- rowCumprods_R(x)
  r1 <- rowCumprods(x)
  r2 <- t(colCumprods(t(x)))
  stopifnot(all.equal(r1, r2))
  stopifnot(all.equal(r1, r0))
  stopifnot(all.equal(r2, r0))


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# A 1x1 matrix
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
x <- matrix(0, nrow=1, ncol=1)
  r0 <- rowCumprods_R(x)
  r1 <- rowCumprods(x)
  r2 <- t(colCumprods(t(x)))
  stopifnot(all.equal(r1, r2))
  stopifnot(all.equal(r1, r0))
  stopifnot(all.equal(r2, r0))

