/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.externalConstraints;

import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.frames.Frame;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DistLeq
extends ExternalConstraint
implements Externalizable {
    public int id;
    public int D;
    public int o1;
    public int o2;
    public int q;
    public IntDomainVar DVar = null;

    public DistLeq() {
    }

    public DistLeq(int ectrID, int[] dimensions, int[] objectIdentifiers, int D_, int q_) {
        this(ectrID, dimensions, objectIdentifiers, D_, q_, null);
    }

    public DistLeq(int ectrID, int[] dimensions, int[] objectIdentifiers, int D_, int q_, IntDomainVar var) {
        super(ectrID, dimensions, null);
        int[] oids = new int[1];
        this.id = ExternalConstraint.maxId++;
        this.D = D_;
        this.o1 = objectIdentifiers[0];
        this.o2 = objectIdentifiers[1];
        this.q = q_;
        oids[0] = this.o1;
        this.setObjectIds(oids);
        this.DVar = var;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this.D);
        out.writeObject(this.o1);
        out.writeObject(this.o2);
        out.writeObject(this.q);
        out.writeObject(this.ectrID);
        out.writeObject(this.dim.length);
        for (i = 0; i < this.dim.length; ++i) {
            out.writeObject(this.dim[i]);
        }
        out.writeObject(this.objectIds.length);
        for (i = 0; i < this.objectIds.length; ++i) {
            out.writeObject(this.objectIds[i]);
        }
        out.writeObject(this.frame);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.D = (Integer)in.readObject();
        this.o1 = (Integer)in.readObject();
        this.o2 = (Integer)in.readObject();
        this.q = (Integer)in.readObject();
        this.ectrID = (Integer)in.readObject();
        int n = (Integer)in.readObject();
        this.dim = new int[n];
        for (i = 0; i < n; ++i) {
            this.dim[i] = (Integer)in.readObject();
        }
        n = (Integer)in.readObject();
        this.objectIds = new int[n];
        for (i = 0; i < n; ++i) {
            this.objectIds[i] = (Integer)in.readObject();
        }
        this.frame = (Frame)in.readObject();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.DVar != null) {
            r.append("Leq(D=[").append(this.DVar.getInf()).append(",").append(this.DVar.getSup()).append("],q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        } else {
            r.append("Leq(D=").append(this.D).append(",q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        }
        return r.toString();
    }

    public boolean hasDistanceVar() {
        return this.DVar != null;
    }

    public IntDomainVar getDistanceVar() {
        return this.DVar;
    }

    public int getCstrId() {
        return this.id;
    }
}

