/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.Comparator;

public class BoundGccVar
extends AbstractLargeIntSConstraint {
    private int[] treelinks;
    private int[] d;
    private int[] h;
    private int[] bounds;
    private int[] stableInterval;
    private int[] potentialStableSets;
    private int[] newMin;
    int offset = 0;
    private int nbBounds;
    int nbVars;
    private IntDomainVar[] card;
    Interval[] minsorted;
    Interval[] maxsorted;
    private final int[] minOccurrences;
    private final int[] maxOccurrences;
    PartialSum l;
    PartialSum u;
    private int firstValue;
    int range;
    IStateInt[] val_maxOcc;
    IStateInt[] val_minOcc;

    public static IntDomainVar[] makeVarTable(IntDomainVar[] vars, IntDomainVar[] card) {
        if (card != null) {
            IntDomainVar[] allvars = new IntDomainVar[vars.length + card.length];
            System.arraycopy(vars, 0, allvars, 0, vars.length);
            System.arraycopy(card, 0, allvars, vars.length, card.length);
            return allvars;
        }
        return vars;
    }

    public BoundGccVar(IntDomainVar[] vars, IntDomainVar[] card, int firstCardValue, int lastCardValue, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, BoundGccVar.makeVarTable(vars, card));
        int i;
        this.card = card;
        int n = vars.length;
        this.range = lastCardValue - firstCardValue + 1;
        this.nbVars = n;
        this.treelinks = new int[2 * n + 2];
        this.d = new int[2 * n + 2];
        this.h = new int[2 * n + 2];
        this.bounds = new int[2 * n + 2];
        this.stableInterval = new int[2 * n + 2];
        this.potentialStableSets = new int[2 * n + 2];
        this.newMin = new int[n];
        Interval[] intervals = new Interval[n];
        this.minsorted = new Interval[n];
        this.maxsorted = new Interval[n];
        for (i = 0; i < this.nbVars; ++i) {
            intervals[i] = new Interval();
            intervals[i].var = vars[i];
            intervals[i].idx = i;
            this.minsorted[i] = intervals[i];
            this.maxsorted[i] = intervals[i];
        }
        this.offset = firstCardValue;
        this.firstValue = firstCardValue;
        this.val_maxOcc = new IStateInt[this.range];
        this.val_minOcc = new IStateInt[this.range];
        for (i = 0; i < this.range; ++i) {
            this.val_maxOcc[i] = environment.makeInt(0);
            this.val_minOcc[i] = environment.makeInt(0);
        }
        this.l = new PartialSum(this.firstValue, this.range);
        this.u = new PartialSum(this.firstValue, this.range);
        this.minOccurrences = new int[this.range];
        this.maxOccurrences = new int[this.range];
    }

    public int getMaxOcc(int i) {
        return this.card[i].getSup();
    }

    public int getMinOcc(int i) {
        return this.card[i].getInf();
    }

    protected void init() {
        for (int i = 0; i < this.range; ++i) {
            this.val_maxOcc[i].set(0);
            this.val_minOcc[i].set(0);
        }
    }

    protected final void sortIt() {
        Arrays.sort(this.minsorted, SORT.MIN);
        Arrays.sort(this.maxsorted, SORT.MAX);
        int min = this.minsorted[0].var.getInf();
        int max = this.maxsorted[0].var.getSup() + 1;
        int last = this.l.firstValue + 1;
        int nb = 0;
        this.bounds[0] = last;
        int i = 0;
        int j = 0;
        while (true) {
            if (i < this.nbVars && min <= max) {
                if (min != last) {
                    this.bounds[++nb] = last = min;
                }
                this.minsorted[i].minrank = nb;
                if (++i >= this.nbVars) continue;
                min = this.minsorted[i].var.getInf();
                continue;
            }
            if (max != last) {
                this.bounds[++nb] = last = max;
            }
            this.maxsorted[j].maxrank = nb;
            if (++j == this.nbVars) break;
            max = this.maxsorted[j].var.getSup() + 1;
        }
        this.nbBounds = nb;
        this.bounds[nb + 1] = this.u.lastValue + 1;
    }

    protected final void pathset(int[] tab, int start, int end, int to) {
        int next;
        int prev = next = start;
        while (prev != end) {
            next = tab[prev];
            tab[prev] = to;
            prev = next;
        }
    }

    protected final int pathmin(int[] tab, int i) {
        while (tab[i] < i) {
            i = tab[i];
        }
        return i;
    }

    protected final int pathmax(int[] tab, int i) {
        while (tab[i] > i) {
            i = tab[i];
        }
        return i;
    }

    protected final void filterLowerMax() throws ContradictionException {
        int i;
        for (i = 1; i <= this.nbBounds + 1; ++i) {
            this.treelinks[i] = this.h[i] = i - 1;
            this.d[i] = this.u.sum(this.bounds[i - 1], this.bounds[i] - 1);
        }
        for (i = 0; i < this.nbVars; ++i) {
            int x = this.maxsorted[i].minrank;
            int y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.treelinks, x + 1);
            int j = this.treelinks[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.treelinks[z] = z + 1;
                z = this.pathmax(this.treelinks, this.treelinks[z]);
                this.treelinks[z] = j;
            }
            this.pathset(this.treelinks, x + 1, z, z);
            if (this.d[z] < this.u.sum(this.bounds[y], this.bounds[z] - 1)) {
                this.fail();
            }
            if (this.h[x] > x) {
                int w = this.pathmax(this.h, this.h[x]);
                this.maxsorted[i].var.updateInf(this.bounds[w], this, true);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.u.sum(this.bounds[y], this.bounds[z] - 1)) continue;
            this.pathset(this.h, this.h[y], j - 1, y);
            this.h[y] = j - 1;
        }
    }

    protected final void filterUpperMax() throws ContradictionException {
        int i;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.treelinks[i] = this.h[i] = i + 1;
            this.d[i] = this.u.sum(this.bounds[i], this.bounds[this.h[i]] - 1);
        }
        i = this.nbVars;
        while (--i >= 0) {
            int x = this.minsorted[i].maxrank;
            int y = this.minsorted[i].minrank;
            int z = this.pathmin(this.treelinks, x - 1);
            int j = this.treelinks[z];
            int n = z;
            this.d[n] = this.d[n] - 1;
            if (this.d[n] == 0) {
                this.treelinks[z] = z - 1;
                z = this.pathmin(this.treelinks, this.treelinks[z]);
                this.treelinks[z] = j;
            }
            this.pathset(this.treelinks, x - 1, z, z);
            if (this.d[z] < this.u.sum(this.bounds[z], this.bounds[y] - 1)) {
                this.fail();
            }
            if (this.h[x] < x) {
                int w = this.pathmin(this.h, this.h[x]);
                this.minsorted[i].var.updateSup(this.bounds[w] - 1, this, false);
                this.pathset(this.h, x, w, w);
            }
            if (this.d[z] != this.u.sum(this.bounds[z], this.bounds[y] - 1)) continue;
            this.pathset(this.h, this.h[y], j + 1, y);
            this.h[y] = j + 1;
        }
    }

    public final void filterLowerMin() throws ContradictionException {
        int y;
        int x;
        int i;
        int w = i = this.nbBounds + 1;
        while (i > 0) {
            this.potentialStableSets[i] = this.stableInterval[i] = i - 1;
            this.d[i] = this.l.sum(this.bounds[i - 1], this.bounds[i] - 1);
            if (this.d[i] == 0) {
                this.h[i - 1] = w;
            } else {
                w = this.h[w] = i - 1;
            }
            --i;
        }
        for (i = w = this.nbBounds + 1; i >= 0; --i) {
            if (this.d[i] == 0) {
                this.treelinks[i] = w;
                continue;
            }
            w = this.treelinks[w] = i;
        }
        for (i = 0; i < this.nbVars; ++i) {
            int v;
            x = this.maxsorted[i].minrank;
            y = this.maxsorted[i].maxrank;
            int z = this.pathmax(this.treelinks, x + 1);
            int j = this.treelinks[z];
            if (z != x + 1) {
                w = this.pathmax(this.potentialStableSets, x + 1);
                v = this.potentialStableSets[w];
                this.pathset(this.potentialStableSets, x + 1, w, w);
                w = y < z ? y : z;
                this.pathset(this.potentialStableSets, this.potentialStableSets[w], v, w);
                this.potentialStableSets[w] = v;
            }
            if (this.d[z] <= this.l.sum(this.bounds[y], this.bounds[z] - 1)) {
                w = this.pathmax(this.stableInterval, this.potentialStableSets[y]);
                this.pathset(this.stableInterval, this.potentialStableSets[y], w, w);
                v = this.stableInterval[w];
                this.pathset(this.stableInterval, this.stableInterval[y], v, y);
                this.stableInterval[y] = v;
            } else {
                int n = z;
                this.d[n] = this.d[n] - 1;
                if (this.d[n] == 0) {
                    this.treelinks[z] = z + 1;
                    z = this.pathmax(this.treelinks, this.treelinks[z]);
                    this.treelinks[z] = j;
                }
                if (this.h[x] > x) {
                    w = this.newMin[i] = this.pathmax(this.h, x);
                    this.pathset(this.h, x, w, w);
                } else {
                    this.newMin[i] = x;
                }
                if (this.d[z] == this.l.sum(this.bounds[y], this.bounds[z] - 1)) {
                    if (this.h[y] > y) {
                        y = this.h[y];
                    }
                    this.pathset(this.h, this.h[y], j - 1, y);
                    this.h[y] = j - 1;
                }
            }
            this.pathset(this.treelinks, x + 1, z, z);
        }
        if (this.h[this.nbBounds] != 0) {
            this.fail();
        }
        for (i = this.nbBounds + 1; i > 0; --i) {
            if (this.stableInterval[i] > i) {
                this.stableInterval[i] = w;
                continue;
            }
            w = i;
        }
        for (i = this.nbVars - 1; i >= 0; --i) {
            x = this.maxsorted[i].minrank;
            y = this.maxsorted[i].maxrank;
            if (this.stableInterval[x] > x && y <= this.stableInterval[x]) continue;
            this.maxsorted[i].var.updateInf(this.l.skipNonNullElementsRight(this.bounds[this.newMin[i]]), this, false);
        }
    }

    public final void filterUpperMin() throws ContradictionException {
        int y;
        int x;
        int i;
        int w = 0;
        int n = this.nbVars;
        for (i = 0; i <= this.nbBounds; ++i) {
            this.d[i] = this.l.sum(this.bounds[i], this.bounds[i + 1] - 1);
            if (this.d[i] == 0) {
                this.treelinks[i] = w;
                continue;
            }
            w = this.treelinks[w] = i;
        }
        this.treelinks[w] = i;
        w = 0;
        for (i = 1; i <= this.nbBounds; ++i) {
            if (this.d[i - 1] == 0) {
                this.h[i] = w;
                continue;
            }
            w = this.h[w] = i;
        }
        this.h[w] = i;
        for (i = n - 1; i >= 0; --i) {
            x = this.minsorted[i].maxrank;
            y = this.minsorted[i].minrank;
            int z = this.pathmin(this.treelinks, x - 1);
            int j = this.treelinks[z];
            if (this.d[z] > this.l.sum(this.bounds[z], this.bounds[y] - 1)) {
                int n2 = z;
                this.d[n2] = this.d[n2] - 1;
                if (this.d[n2] == 0) {
                    this.treelinks[z] = z - 1;
                    z = this.pathmin(this.treelinks, this.treelinks[z]);
                    this.treelinks[z] = j;
                }
                if (this.h[x] < x) {
                    this.newMin[i] = w = this.pathmin(this.h, this.h[x]);
                    this.pathset(this.h, x, w, w);
                } else {
                    this.newMin[i] = x;
                }
                if (this.d[z] == this.l.sum(this.bounds[z], this.bounds[y] - 1)) {
                    if (this.h[y] < y) {
                        y = this.h[y];
                    }
                    this.pathset(this.h, this.h[y], j + 1, y);
                    this.h[y] = j + 1;
                }
            }
            this.pathset(this.treelinks, x - 1, z, z);
        }
        for (i = n - 1; i >= 0; --i) {
            x = this.minsorted[i].minrank;
            y = this.minsorted[i].maxrank;
            if (this.stableInterval[x] > x && y <= this.stableInterval[x]) continue;
            this.minsorted[i].var.updateSup(this.l.skipNonNullElementsLeft(this.bounds[this.newMin[i]] - 1), this, false);
        }
    }

    public final void initBackDataStruct() throws ContradictionException {
        for (int i = 0; i < this.range; ++i) {
            for (int j = 0; j < this.nbVars; ++j) {
                if (((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(i + this.offset)) {
                    this.val_maxOcc[i].add(1);
                }
                if (!((IntDomainVar[])this.vars)[j].isInstantiatedTo(i + this.offset)) continue;
                this.val_minOcc[i].add(1);
            }
        }
    }

    private void initCard() throws ContradictionException {
        for (int i = 0; i < this.range; ++i) {
            if (this.val_maxOcc[i].get() == 0) {
                this.card[i].instantiate(0, this, false);
                continue;
            }
            this.card[i].updateInf(this.val_minOcc[i].get(), this, false);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.init();
        this.initBackDataStruct();
        this.initCard();
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            if (!var.isInstantiated()) continue;
            if (i < this.nbVars) {
                int val = ((IntDomainVar[])this.vars)[i].getVal();
                this.filterBCOnInst(val);
                continue;
            }
            this.filterBCOnInst(i - this.nbVars + this.offset);
        }
        if (this.directInconsistentCount()) {
            this.fail();
        }
        this.propagate();
    }

    public boolean directInconsistentCount() {
        for (int i = 0; i < this.range; ++i) {
            if (this.val_maxOcc[i].get() >= this.card[i].getInf() && this.val_minOcc[i].get() <= this.card[i].getSup()) continue;
            return true;
        }
        return false;
    }

    public final void dynamicInitOfPartialSum() {
        for (int i = 0; i < this.range; ++i) {
            this.maxOccurrences[i] = this.card[i].getSup();
            this.minOccurrences[i] = this.card[i].getInf();
        }
        this.l.compute(this.minOccurrences);
        this.u.compute(this.maxOccurrences);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.propagateSumCard();
        this.dynamicInitOfPartialSum();
        this.sortIt();
        assert (this.l.minValue() == this.u.minValue());
        assert (this.l.maxValue() == this.u.maxValue());
        assert (this.l.minValue() <= this.minsorted[0].var.getInf());
        assert (this.maxsorted[this.nbVars - 1].var.getSup() <= this.u.maxValue());
        assert (!this.directInconsistentCount());
        if (this.l.sum(this.l.minValue(), this.minsorted[0].var.getInf() - 1) > 0 || this.l.sum(this.maxsorted[this.nbVars - 1].var.getSup() + 1, this.l.maxValue()) > 0) {
            this.fail();
        }
        this.filterLowerMax();
        this.filterLowerMin();
        this.filterUpperMax();
        this.filterUpperMin();
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        this.constAwake(false);
        if (i < this.nbVars && !((IntDomainVar[])this.vars)[i].hasEnumeratedDomain()) {
            this.filterBCOnInf(i);
        }
    }

    public final void filterBCOnInf(int i) throws ContradictionException {
        int inf = ((IntDomainVar[])this.vars)[i].getInf();
        int nbInf = this.val_minOcc[inf - this.offset].get();
        if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(inf)) {
            --nbInf;
        }
        if (nbInf == this.getMaxOcc(inf - this.offset)) {
            ((IntDomainVar[])this.vars)[i].updateInf(inf + 1, this, true);
        }
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        this.constAwake(false);
        if (i < this.nbVars && !((IntDomainVar[])this.vars)[i].hasEnumeratedDomain()) {
            this.filterBCOnSup(i);
        }
    }

    public final void filterBCOnSup(int i) throws ContradictionException {
        int sup = ((IntDomainVar[])this.vars)[i].getSup();
        int nbSup = this.val_minOcc[sup - this.offset].get();
        if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(sup)) {
            --nbSup;
        }
        if (nbSup == this.getMaxOcc(sup - this.offset)) {
            ((IntDomainVar[])this.vars)[i].updateSup(sup - 1, this, true);
        }
    }

    @Override
    public void awakeOnInst(int i) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[i].getVal();
        this.constAwake(false);
        if (i < this.nbVars) {
            this.val_minOcc[val - this.offset].add(1);
            this.card[val - this.offset].updateInf(this.val_minOcc[val - this.offset].get(), this, false);
            this.filterBCOnInst(val);
        } else {
            this.filterBCOnInst(i - this.nbVars + this.offset);
        }
    }

    public final void filterBCOnInst(int val) throws ContradictionException {
        int nbvalsure = this.val_minOcc[val - this.offset].get();
        if (nbvalsure > this.getMaxOcc(val - this.offset)) {
            this.fail();
        } else if (nbvalsure == this.getMaxOcc(val - this.offset)) {
            for (int j = 0; j < this.nbVars; ++j) {
                if (((IntDomainVar[])this.vars)[j].isInstantiatedTo(val)) continue;
                ((IntDomainVar[])this.vars)[j].removeVal(val, this, true);
            }
        }
    }

    public final void filterBCOnRem(int val) throws ContradictionException {
        int nbpos = this.val_maxOcc[val - this.offset].get();
        if (nbpos < this.getMinOcc(val - this.offset)) {
            this.fail();
        } else if (nbpos == this.getMinOcc(val - this.offset)) {
            for (int j = 0; j < this.nbVars; ++j) {
                if (!((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(val)) continue;
                ((IntDomainVar[])this.vars)[j].instantiate(val, this, true);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int i) throws ContradictionException {
        if (idx < this.nbVars) {
            this.val_maxOcc[i - this.offset].add(-1);
            this.card[i - this.offset].updateSup(this.val_maxOcc[i - this.offset].get(), this, true);
        }
    }

    public final void propagateSumCard() throws ContradictionException {
        boolean fixpoint = true;
        while (fixpoint) {
            int i;
            fixpoint = false;
            int lb = 0;
            int ub = 0;
            for (i = 0; i < this.range; ++i) {
                lb += this.card[i].getInf();
                ub += this.card[i].getSup();
            }
            for (i = 0; i < this.range; ++i) {
                fixpoint |= this.card[i].updateSup(this.nbVars - (lb - this.card[i].getInf()), this, false);
                fixpoint |= this.card[i].updateInf(this.nbVars - (ub - this.card[i].getSup()), this, false);
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int[] occurrences = new int[this.range];
        for (i = 0; i < this.nbVars; ++i) {
            int n = tuple[i] - this.offset;
            occurrences[n] = occurrences[n] + 1;
        }
        for (i = 0; i < occurrences.length; ++i) {
            int occurrence = occurrences[i];
            if (tuple[this.nbVars + i] == occurrence) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("BoundGccV({");
        for (i = 0; i < this.nbVars; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.range; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("#").append(this.offset + i).append(" = ").append(((IntDomainVar[])this.vars)[this.nbVars + i].pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on package choco.kernel.solver.constraints.global.BoundAlldiff");
    }

    static final class PartialSum {
        private int[] sum;
        private int[] ds;
        private int firstValue;
        private int lastValue;
        private int range;

        public PartialSum(int firstValue, int count) {
            this.range = count;
            this.sum = new int[count + 5];
            this.ds = new int[count + 5];
            this.firstValue = firstValue - 3;
            this.lastValue = firstValue + count + 1;
        }

        public void compute(int[] elt) {
            int i;
            this.sum[0] = 0;
            this.sum[1] = 1;
            this.sum[2] = 2;
            for (i = 2; i < this.range + 2; ++i) {
                this.sum[i + 1] = this.sum[i] + elt[i - 2];
            }
            this.sum[i + 1] = this.sum[i] + 1;
            this.sum[i + 2] = this.sum[i + 1] + 1;
            i = this.range + 3;
            int j = i + 1;
            while (i > 0) {
                while (this.sum[i] == this.sum[i - 1]) {
                    this.ds[i--] = j;
                }
                this.ds[j] = i--;
                j = this.ds[j];
            }
            this.ds[j] = 0;
        }

        public int sum(int from, int to) {
            if (from <= to) {
                return this.sum[to - this.firstValue] - this.sum[from - this.firstValue - 1];
            }
            return this.sum[to - this.firstValue - 1] - this.sum[from - this.firstValue];
        }

        public int minValue() {
            return this.firstValue + 3;
        }

        public int maxValue() {
            return this.lastValue - 2;
        }

        public int skipNonNullElementsRight(int value) {
            return (this.ds[value -= this.firstValue] < value ? value : this.ds[value]) + this.firstValue;
        }

        public int skipNonNullElementsLeft(int value) {
            return (this.ds[value -= this.firstValue] > value ? this.ds[this.ds[value]] : value) + this.firstValue;
        }
    }

    protected static class Interval {
        int minrank;
        int maxrank;
        IntDomainVar var;
        int idx;

        protected Interval() {
        }
    }

    static enum SORT implements Comparator<Interval>
    {
        MAX{

            @Override
            public int compare(Interval o1, Interval o2) {
                return o1.var.getSup() - o2.var.getSup();
            }
        }
        ,
        MIN{

            @Override
            public int compare(Interval o1, Interval o2) {
                return o1.var.getInf() - o2.var.getInf();
            }
        };

    }
}

