% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marima.R
\name{marima}
\alias{marima}
\title{marima}
\source{
The code is an R code which is based on the
article (below) by Spliid (1983). A repeated (socalled) pseudo
regression procedure is used in order to estimate the multivariate
arma model.
}
\usage{
marima(DATA = NULL, ar.pattern = NULL, ma.pattern = NULL, means = 1,
  max.iter = 50, penalty = 0, weight = 0.33, Plot = "none",
  Check = FALSE)
}
\arguments{
\item{DATA}{time series matrix, dim(DATA) = c(kvar, n), 
where 'kvar' is the dimension of the time series and 'n' is the
length of the series. If DATA is organized (n, kvar) (as a data.frame
e.g.) it is automatically transposed in marima, and the user need
not care about it. Also, and consequently, the output residuals and
fitted values matrices are both organised c(kvar, n) at return from marima.
The DATA is checked for completeness. Cases which include 'NA's or 'NaN's
are initially left out. A message is given (on the console) and the active
cases are given in the output object (...$used.cases). If DATA is a time
series object it is transformed to a matrix and a warning is given
( if(is.ts(DATA)) { DATA <- as.matrix(data.frame(DATA)) } and a message
is given (on the console).}

\item{ar.pattern}{autoregressive pattern for model (see define.model).
If ar.pattern is not specified a pure ma-model is estimated.}

\item{ma.pattern}{moving average pattern for model (see define.model).
If ma.pattern is not specified a pure ar-model is estimated. In this case
the estimation is carried out by regression analysis in a few steps.}

\item{means}{0/1 indicator vector of length kvar, indicating
which variables in the analysis should be means adjusted or not.
Default: means=1 and all variables are means adjusted.
If means=0 is used, no variables are means adjusted.}

\item{max.iter}{max. number of iterations in estimation (max.iter=50
is default which, generally, is more than enough).}

\item{penalty}{parameter used in the R function 'step' for
stepwise model reduction. If penalty=2, the conventional
AIC criterion is used. If penalty=0, no stepwise reduction of model is
performed. Generally 0<=penalty<=2 works well (especially penalty=1).
The level of
significance of the individual parameter estimates in the final
model can be checked by considering the (approximate) 'ar.pvalues'
and the 'ma.pvalues' calculated by marima.}

\item{weight}{weighting factor for smoothing the repeated
estimation procedure. Default is weight=0.33 which often works
well. If weight>0.33 (e.g. weight=0.66) is specified more damping
will result. If a large damping factor is used, the successive
estimations are more cautious, and a slower (but safer)
convergence (if possible) may result (max.iter may have to be
increased to, say, max.iter=75.}

\item{Plot}{'none' or 'trace' or 'log.det' indicates a plot that shows
how the residual covariance matrix (resid.cov) develops with the
iterations.
If Plot= 'none' no plot is generated.
If Plot= 'trace' a plot of the trace of the residual
covariance matrix versus iterations is generated.
If Plot='log.det' the log(determinant) of the residual
covariance matrix (resid.cov) is generated. Default is Plot= 'none'.}

\item{Check}{(TRUE/FALSE) results (if TRUE) in a printout of some
controls of the call to arima. Useful in the first attemp(s) to use
marima. Default=FALSE.}
}
\value{
Object of class marima containing:

 N            = N length of analysed series

 kvar         = dimension of time series (all random and
   non-random variables).

 ar.estimates = ar-estimates

 ma.estimates = ma-estimates

 ar.fvalues   = ar-fvalues (approximate)

 ma.fvalues   = ma-fvalues (approximate)

 ar.pvalues   = ar-p-values (approximate)

 ma.pvalues   = ma-p-values (approximate)

 residuals = estimated residuals (for used.cases), leading values
 (not estimated values) are put equal to NA

 fitted    = estimated/fitted values for all data
(including non random variables) (for used.cases), leading values
(not estimated values) are put equal to NA

 resid.cov = covariance matrix of residuals
(including non random variables) (computed for used.cases)

 data.cov  = covariance matrix of (all)
 input data (for used.cases)

 averages  = averages of input variables

 Constant  = estimated model constant =
                            (sum_i(ar[, , i])) x averages

 call.ar.pattern = calling ar.pattern

 call.ma.pattern = calling ma.pattern

 out.ar.pattern = resulting ar.pattern
            (after possible model reduction)

 out.ma.pattern = resulting ar.pattern
            (after possible model reduction)

 max.iter = max no. of iterations in call

 penalty = factor used in AIC model reduction

 weight  = weighting of successive residuals
                    updating (default=0.33)

 used.cases = cases in input which are analysed

 trace   = trace(random part of resid.cov)

 log.det = log(det(random part of resid.cov))

 randoms = which are random variables in problem?

 one.step = one step ahead prediction (for time = N+1)
 based on whole series from obs. 1 to N. The computation
 is based on the marima residuals (as taken from the last
 regression step in the repeated pseudo-regression algorithm).
}
\description{
Estimate multivariate arima and arima-x models.
Setting up the proper model for (especially) arima-x estimation
can be accomplished using the routine 'define.model' that can
assist in setting up the necessary autoregressive and moving average
patterns used as input to 'marima'.

A more elaborate description of 'marima' and how it is used
can be downloaded from:

http://www.imm.dtu.dk/~hspl/marima.use.pdf
}
\examples{
# Example 1:
library(marima)
# Generate a 4-variate time series (in this example):
#
kvar<-4 ; set.seed(4711)
y4<-matrix(round(100*rnorm(4*1000, mean=2.0)), nrow=kvar)
# If wanted define differencing of variable 4 (lag=1)
# and variable 3 (lag=6), for example:
y4.dif<-define.dif(y4, difference=c(4, 1, 3, 6))
# The differenced series will be in y4.dif$y.dif, the observations
# lost by differencing being excluded.
#
y4.dif.analysis<-y4.dif$y.dif
# Give lags the be included in ar- and ma-parts of model:
#
ar<-c(1, 2, 4)
ma<-c(1)
# Define the multivariate arma model using 'define.model' procedure.
# Output from 'define.model' will be the patterns of the ar- and ma-
# parts of the model specified.
#
Mod <- define.model(kvar=4, ar=ar, ma=ma, reg.var=3)
arp<-Mod$ar.pattern
map<-Mod$ma.pattern
# Print out model in 'short form':
#
short.form(arp)
short.form(map)
# Now call marima:
Model <- marima(y4.dif.analysis, ar.pattern=arp, ma.pattern=map, 
                penalty=0.0)
# The estimated model is in the object 'Model':
#
ar.model<-Model$ar.estimates
ma.model<-Model$ma.estimates
dif.poly<-y4.dif$dif.poly  # = difference polynomial in ar-form.
# Multiply the estimated ar-polynomial with difference polynomial
# to compute the aggregated ar-part of the arma model:
#
ar.aggregated <- pol.mul(ar.model, dif.poly, L=12)
# and print everything out in 'short form':
#
short.form(ar.aggregated, leading=FALSE)
short.form(ma.model, leading=FALSE)

}
\references{
Jenkins, G.M. & Alavi, A. (1981): Some aspects of modelling and forecasting
    multivariate time series, Journal of Time Series Analysis, 
    Vol. 2, issue 1, Jan. 1981, pp. 1-47.

Madsen, H. (2008) Time Series Analysis, Chapmann \& Hall (in particular
chapter 9: Multivariate time series).

Reinsel, G.C. (2003) Elements of Multivariate Time Series Analysis, 
Springer Verlag, 2$^{nd}$ ed. pp. 106-114.

Shumway, R.H. & Stoffer, D.S. (2000). Time Series Analysis and
Its Applications, Springer Verlag, (4$^{th}$ ed. 2016).

Spliid, H.: A Fast Estimation Method for the Vector
   Autoregressive Moving Average Model With Exogenous Variables, Journal
   of the American Statistical Association, Vol. 78, No. 384, Dec. 1983, 
   pp. 843-849.

Spliid, H.: Estimation of Multivariate Time Series
with Regression Variables:

http://www.imm.dtu.dk/~hspl/marima.use.pdf

www.itl.nist.gov/div898/handbook/pmc/section4/pmc45.htm
}

