% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{addStaticLabels}
\alias{addStaticLabels}
\title{Add static labels to \code{leaflet} or \code{mapview} objects}
\usage{
addStaticLabels(map, data, label, group = NULL, layerId = NULL, ...)
}
\arguments{
\item{map}{A \code{leaflet} or \code{mapview} object.}

\item{data}{A \code{sf} or \code{Spatial*} object used for label placement,
defaults to the locations of the first dataset in 'map'.}

\item{label}{The labels to be placed at the positions indicated by 'data' as
\code{character}, or any vector that can be coerced to this type.}

\item{group}{the group of the static labels layer.}

\item{layerId}{the layerId of the static labels layer.}

\item{...}{Additional arguments passed to
\code{\link[leaflet]{labelOptions}}.}
}
\value{
A labelled \strong{mapview} object.
}
\description{
Being a wrapper around \code{\link[leaflet]{addLabelOnlyMarkers}}, this
function provides a smart-and-easy solution to add custom text labels to an
existing \code{leaflet} or \code{mapview} map object.
}
\details{
This function is deprecated.
Please use leafem::\code{\link[leafem]{addStaticLabels}} instead.
}
\examples{
\dontrun{
## leaflet label display options
library(leaflet)

lopt = labelOptions(noHide = TRUE,
                    direction = 'top',
                    textOnly = TRUE)

## point labels
m1 = mapview(breweries)
l1 = addStaticLabels(m1,
                     label = breweries$number.of.types,
                     labelOptions = lopt)
l1

## polygon centroid labels
m2 = mapview(franconia)
l2 = addStaticLabels(m2,
                     label = franconia$NAME_ASCI,
                     labelOptions = lopt)
l2

## custom labels
m3 = m2 + m1
l3 = addStaticLabels(m3,
                     data = franconia,
                     label = franconia$NAME_ASCI,
                     labelOptions = lopt)
l3
}

}
\seealso{
\code{\link[leafem]{addStaticLabels}}, \code{\link[leaflet]{addLabelOnlyMarkers}}.
}
\author{
Florian Detsch
}
