% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plainView.R
\docType{methods}
\name{plainView}
\alias{plainView}
\alias{plainView,RasterLayer-method}
\alias{plainView,RasterStackBrick-method}
\alias{plainView,SpatialPixelsDataFrame-method}
\alias{plainview}
\alias{plainview,ANY-method}
\title{View spatial objects interactively without background map but in any CRS}
\usage{
\S4method{plainView}{RasterLayer}(x,
  maxpixels = mapviewGetOption("maxpixels"),
  col.regions = mapviewGetOption("raster.palette")(256), at,
  na.color = mapviewGetOption("na.color"),
  verbose = mapviewGetOption("verbose"), layer.name = deparse(substitute(x,
  env = parent.frame())), ...)

\S4method{plainView}{RasterStackBrick}(x, r = 3, g = 2, b = 1,
  na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("maxpixels"),
  layer.name = deparse(substitute(x, env = parent.frame())), ...)

\S4method{plainView}{SpatialPixelsDataFrame}(x, zcol = 1, ...)

\S4method{plainview}{ANY}(...)
}
\arguments{
\item{x}{a \code{\link{raster}}* object}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{col.regions}{color (palette).See \code{\link{levelplot}} for details.}

\item{at}{the breakpoints used for the visualisation. See
\code{\link{levelplot}} for details.}

\item{na.color}{color for missing values}

\item{verbose}{should some details be printed during the process}

\item{layer.name}{the name of the layer to be shown on the map}

\item{...}{additional arguments passed on to repective functions.
See \code{\link{addRasterImage}}, \code{\link{addCircles}},
\code{\link{addPolygons}}, \code{\link{addPolylines}} for details}

\item{r}{integer. Index of the Red channel, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel, between 1 and nlayers(x)}

\item{zcol}{attribute name or column number in attribute table
of the column to be rendered}
}
\description{
this function produces an interactive view of the specified
spatial object(s) on a plain grey background but for any CRS.
}
\section{Methods (by class)}{
\itemize{
\item \code{RasterStackBrick}: \code{\link{stack}} / \code{\link{brick}}

\item \code{SpatialPixelsDataFrame}: \code{\link{SpatialPixelsDataFrame}}

\item \code{ANY}: alias for ease of typing
}}
\examples{
\dontrun{
plainView()

### raster data ###
library(sp)
library(raster)

data(meuse.grid)
coordinates(meuse.grid) = ~x+y
proj4string(meuse.grid) <- CRS("+init=epsg:28992")
gridded(meuse.grid) = TRUE
meuse_rst <- stack(meuse.grid)

# raster stack
m1 <- plainView(poppendorf[[10]])
m1

# SpatialPixelsDataFrame
plainView(meuse.grid, zcol = "soil")


### point vector data ###
## SpatialPointsDataFrame ##
data(meuse)
coordinates(meuse) <- ~x+y
proj4string(meuse) <- CRS("+init=epsg:28992")

# all layers of meuse
plainView(meuse, burst = TRUE)

# only one layer, all info in popups
plainView(meuse)

## SpatialPoints ##
meuse_pts <- as(meuse, "SpatialPoints")
plainView(meuse_pts)



### overlay vector on top of raster ###
plainView(meuse.grid, zcol = "ffreq") + meuse

### polygon vector data ###
data("gadmCHE")
m <- plainView(gadmCHE)
m

## points on polygons ##
centres <- data.frame(coordinates(gadmCHE))
names(centres) <- c("x", "y")
coordinates(centres) <- ~ x + y
projection(centres) <- projection(gadmCHE)
m + centres

### lines vector data
data("atlStorms2005")
plainView(atlStorms2005)
plainView(atlStorms2005, burst = TRUE)
}

}
\author{
Tim Appelhans

Stephan Woellauer
}

