% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_leg_c.R
\name{mf_legend_c}
\alias{mf_legend_c}
\title{Plot a legend for a choropleth map}
\usage{
mf_legend_c(
  pos = "topleft",
  val,
  pal,
  title = "Legend Title",
  title_cex = 0.8,
  val_cex = 0.6,
  val_rnd = 2,
  col_na = "white",
  no_data = FALSE,
  no_data_txt = "No Data",
  frame = FALSE,
  border,
  bg,
  fg,
  cex = 1
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "right", "bottomright", "bottom", "bottomleft",
"left", "interactive" or a vector of two coordinates in map units
(c(x, y))}

\item{val}{break labels}

\item{pal}{a set of colors.}

\item{title}{title of the legend}

\item{title_cex}{size of the legend title}

\item{val_cex}{size of the values in the legend}

\item{val_rnd}{number of decimal places of the values in
the legend.}

\item{col_na}{color for missing values}

\item{no_data}{if TRUE a "missing value" box is plotted}

\item{no_data_txt}{label for missing values}

\item{frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{border}{color of the boxes' borders}

\item{bg}{background of the legend}

\item{fg}{foreground of the legend}

\item{cex}{size of the legend; 2 means two times bigger}
}
\value{
No return value, a legend is displayed.
}
\description{
Deprecated.

This function plots a legend for a choropleth map.
}
\examples{
\dontrun{
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
mf_legend_c(val = c(1, 2, 3, 4), pal = c("red1", "red3", "red4"))
}
}
\keyword{internal}
