context("Two point estimates")
test_that("estimate two-points rf correctly", {
  dat <- filter_missing(tetra.solcap.geno.dist, inter = FALSE)
  expect_equal(mean(as.matrix(dat$geno.dose)), 1.92626, tolerance = 1e-4)
  dat <- filter_missing(tetra.solcap.geno.dist, inter = FALSE, type = "individual")
  expect_equal(mean(as.matrix(dat$geno.dose)), 1.93118, tolerance = 1e-4)
  f <- filter_segregation(dat, inter = FALSE)
  expect_equivalent(length(f$keep), 3677)
  s <- make_seq_mappoly(tetra.solcap.geno.dist, f$keep)
  s <- make_seq_mappoly(tetra.solcap.geno.dist, s$seq.mrk.names[seq(1,length(s$seq.num), 50)])
  tpt1 <- est_pairwise_rf(s)
  expect_is(plot(tpt1, first.mrk = 1, second.mrk = 101), "ggplot")
  tpt11 <- est_pairwise_rf(s, est.type = "prob")
  expect_is(plot(tpt11, first.mrk = 1, second.mrk = 101), "ggplot")
  m <- rf_list_to_matrix(tpt1)
  m2 <- make_mat_mappoly(m, make_seq_mappoly(tetra.solcap.geno.dist, names(which(s$chrom==1))))
  expect_equal(sum(m2$rec.mat, na.rm = TRUE), 12.51488, tolerance = 10e-5)
  m11 <- rf_list_to_matrix(tpt11)
  m12 <- make_mat_mappoly(m11, make_seq_mappoly(tetra.solcap.geno.dist, names(which(s$chrom==1))))
  expect_equal(sum(m12$rec.mat, na.rm = TRUE), 12.54115, tolerance = 10e-5)
  o <- mds_mappoly(m)
  expect_is(o, "mappoly.pcmap")
  expect_null(plot(m))
  expect_equivalent(round(mean(m[[4]], na.rm = T),6), 0.395504)
  skip_on_os("mac")
  tpt2 <- est_pairwise_rf(s, ncpus = 2)
  expect_equal(tpt1, tpt2, tolerance = 1e-4)
  tpt13 <- est_pairwise_rf(s, ncpus = 2, est.type = "prob")
  expect_equal(tpt11, tpt13, tolerance = 1e-4)
  sf<-rf_snp_filter(tpt2)
  sf2<-rf_snp_filter(tpt13)
  expect_is(sf, "mappoly.sequence")
  expect_is(sf2, "mappoly.sequence")
  expect_equal(sum(sf$seq.num), 135208)
  expect_equal(sum(sf2$seq.num), 135208)
  tpt2 <- est_pairwise_rf2(s, ncpus = 2)
  expect_equal(round(sum(tpt2$pairwise$rf - m$rec.mat, na.rm = TRUE),3), 0)
})