% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gsw_recurrence.R
\name{gsw_recurrence}
\alias{gsw_recurrence}
\alias{calc_gsw_recurrence}
\title{Calculate Global Surface Water (GSW) Recurrence}
\usage{
calc_gsw_recurrence(engine = "extract", min_recurrence = NULL)
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract". Default: "extract".}

\item{min_recurrence}{Threshold to define which pixels count towards the GSW
recurrence area \verb{[0, 100]}.}
}
\value{
A function that returns an indicator tibble with recurrence as
variable and the corresponding area (in ha) as value.
}
\description{
Water Recurrence is a measurement of the degree of variability in the
presence of water from year to year. It describes the frequency with which
water returned to a particular location from one year to another, and is
expressed as a percentage. The raster files have integer cell values between
\verb{[0, 100]}, where 100 represents that water reoccurs predictably every year,
whereas lower values indicate that water only occurs episodically.
}
\details{
The raw data values are aggregated based on a provided threshold parameter
\code{min_recurrence}, the function returns the area covered by values
greater or equal than this threshold.

The required resources for this indicator are:
\itemize{
\item \link{global_surface_water_recurrence}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_global_surface_water_recurrence()) \%>\%
  calc_indicators(
    calc_gsw_recurrence(engine = "extract", min_recurrence = 10)
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
