% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{download_or_skip}
\alias{download_or_skip}
\title{Helper to check and download urls}
\usage{
download_or_skip(
  urls = NULL,
  filenames = NULL,
  verbose = mapme_options()[["verbose"]],
  stubbornness = 6,
  check_existence = TRUE,
  aria_bin = mapme_options()[["aria_bin"]]
)
}
\arguments{
\item{urls}{A character vector with URLs to be downloaded.}

\item{filenames}{A character vector with local file paths the same length
as \code{urls}}

\item{verbose}{A logical controlling the verbosity.}

\item{stubbornness}{A numeric indicating the number of retries for failed
downloads.}

\item{check_existence}{A logical indicating if \code{urls} are to be checked
before trying to download. Defaults to TRUE.}

\item{aria_bin}{A character vector pointing towards an aria2c executable.}
}
\description{
Use this function to fetch a number of remote URLs to local files.
In case of unreliable source servers, failed downlaods are retried up to
the number of times specified with \code{stubbornness}. A path to an aria2c
executable can be specified to use it instead of the default R download
function.
}
\keyword{utils}
