% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPI_GridHexagonal.R
\name{MAPI_GridHexagonal}
\alias{MAPI_GridHexagonal}
\title{Function MAPI_GridHexagonal}
\usage{
MAPI_GridHexagonal(samples, crs, hw, buf = 0)
}
\arguments{
\item{samples}{a data.frame with names and geographical coordinates of samples. Column names must be: 'ind', 'x', 'y'.
Optional column 'errRad' with an error radius for sample locations (eg. GPS uncertainty).
Coordinates must be projected (not latitude/longitude).}

\item{crs}{coordinate reference system: integer with the EPSG code, or character with proj4string.
When using dummy coordinates (eg. simulation output) you may use EPSG:3857 for example.
This allows computation but, of course, has no geographical meaning.}

\item{hw}{Halfwidth : side length of hexagonal cells.}

\item{buf}{optional. This parameter allows to expand or shrink the grid by a number of units in
the same reference system as the sample geographical coordinates (0 by default).}
}
\value{
a spatial object of class 'sf' including the x and y coordinates of cell centers, cell geometry (polygons) and cell id (gid).
}
\description{
Build a grid of hexagonal cells according to samples coordinates and a given halfwidth
cell value provided by users (can be computed using \code{\link{MAPI_EstimateHalfwidth}}).
}
\examples{
data("samples")
# Builds a grid of hexagonal cells according to samples coordinates (columns x and y) 
# using the EPSG:3857 projection and an halfwidth cell value of hw=250m.
grid <- MAPI_GridHexagonal(samples, crs=3857, hw=250)

}
