% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_title.R
\name{add_title}
\alias{add_title}
\title{Add Title}
\usage{
add_title(map, title, layer_id = NULL)
}
\arguments{
\item{map}{a mapdeck map object}

\item{title}{Either a single string for the title, or a list with a 'title' element,
and an optional 'css' element. See examples}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}
}
\description{
Adds a title to a map
}
\examples{
\donttest{

mapdeck() \%>\%
  add_title(title = "first title", layer_id = "first") \%>\%
  add_title(title = list(
      title = "second title",
      css = "background-color: red;"),
    layer_id = "second") \%>\%
  add_title(title = list(
      title = "Another title",
      css = "background-color: transparent;"),
    layer_id = "third")

}

}
