context("polygon")


test_that("add_polygon accepts multiple objects", {

	testthat::skip_on_cran()
	testthat::skip_on_travis()

	library(sf)

	geo <- '[{"type":"Feature","properties":{"elevation":0,"fill_colour":"#440154FF","stroke_colour":"#440154FF"},"geometry":{"geometry":{"type":"Polygon","coordinates":[[[144.9745331,-37.8346672],[144.9744415,-37.8345604],[144.9741821,-37.8342705],[144.9741058,-37.8341904],[144.973999,-37.8341179],[144.9736328,-37.8338776],[144.973465,-37.8337593],[144.9734039,-37.833717300000007],[144.9728088,-37.8332901],[144.972641,-37.8331795],[144.9725037,-37.8330574],[144.9723663,-37.8329391],[144.9722443,-37.8328094],[144.9788971,-37.8336678],[144.9799194,-37.8337975],[144.9807129,-37.8339081],[144.9812775,-37.8339806],[144.9825134,-37.8341408],[144.9833527,-37.8342476],[144.9836731,-37.8342896],[144.9837952,-37.8336678],[144.9838715,-37.8332596],[144.9840851,-37.8321991],[144.9844208,-37.8305092],[144.9844818,-37.8301392],[144.9845734,-37.8297501],[144.9846191,-37.8294601],[144.9847107,-37.828968],[144.984848,-37.8283386],[144.9850006,-37.8283882],[144.9851837,-37.8284492],[144.9853516,-37.8285294],[144.9855042,-37.8286095],[144.9856567,-37.8286972],[144.9858093,-37.8287888],[144.9859467,-37.8288994],[144.9860687,-37.82901],[144.9865417,-37.8293686],[144.9872894,-37.8300781],[144.9875488,-37.8303185],[144.9877777,-37.8305473],[144.9878387,-37.8306274],[144.9878693,-37.830719],[144.9878845,-37.8307686],[144.9878998,-37.8308487],[144.987915,-37.8309288],[144.987915,-37.8309479],[144.9879303,-37.8310089],[144.9879303,-37.831089],[144.9879303,-37.8311691],[144.9879303,-37.8312378],[144.9879303,-37.8313179],[144.987915,-37.831398],[144.9878387,-37.8317184],[144.9877472,-37.8322487],[144.9877014,-37.832489],[144.9875793,-37.8330574],[144.9875183,-37.8334084],[144.9874268,-37.8338509],[144.987381,-37.8341408],[144.9872589,-37.8347588],[144.9872131,-37.8349609],[144.9871063,-37.8354683],[144.9870911,-37.8354988],[144.9870148,-37.8359184],[144.9869843,-37.8360481],[144.9868469,-37.8367195],[144.9867706,-37.8371086],[144.9867401,-37.8372688],[144.9866333,-37.83778],[144.98660279999999,-37.8379478],[144.9865112,-37.8383179],[144.9864502,-37.8386307],[144.9863281,-37.8392677],[144.9863129,-37.8393173],[144.986145,-37.8401375],[144.986084,-37.8404694],[144.9859772,-37.8410072],[144.9858704,-37.8414879],[144.9858398,-37.8416672],[144.9856873,-37.8423882],[144.9855652,-37.8429794],[144.9855499,-37.8430672],[144.9854126,-37.8437004],[144.9854126,-37.8437805],[144.9852905,-37.8443489],[144.9852295,-37.8446083],[144.9850159,-37.8456802],[144.9849396,-37.8461189],[144.9847717,-37.8470497],[144.9847412,-37.8472481],[144.9847107,-37.8474083],[144.9845734,-37.8483391],[144.9843292,-37.8498383],[144.9841919,-37.8506584],[144.9830322,-37.8505096],[144.9823303,-37.8504295],[144.9806366,-37.8502083],[144.9804382,-37.849659],[144.9803314,-37.8493881],[144.9801483,-37.8488579],[144.9797211,-37.8477173],[144.9795074,-37.8471107],[144.9794159,-37.8468704],[144.9790802,-37.845970199999999],[144.9786835,-37.8448486],[144.9785614,-37.8445473],[144.9783936,-37.8440475],[144.9782715,-37.843708],[144.9781342,-37.8433609],[144.9779968,-37.8429909],[144.9779205,-37.8427582],[144.9778137,-37.8424797],[144.9777222,-37.8422279],[144.9775391,-37.8417282],[144.9774017,-37.8413391],[144.9772797,-37.8410187],[144.9770813,-37.8404694],[144.9769897,-37.8402176],[144.9768829,-37.8399506],[144.9767914,-37.8396797],[144.9765778,-37.8390694],[144.9764404,-37.8387184],[144.9763489,-37.8384476],[144.9762573,-37.8381996],[144.976059,-37.8376694],[144.9758606,-37.8371506],[144.9755249,-37.8362083],[144.9754791,-37.8360672],[144.9754333,-37.835968],[144.9753418,-37.8358307],[144.9751892,-37.8355675],[144.9750366,-37.8353195],[144.9749756,-37.8351974],[144.9749298,-37.8351173],[144.9748688,-37.8350487],[144.9745331,-37.8346672]]]}}}]'
	poly <- '[{"elevation":0,"fill_colour":"#440154FF","stroke_colour":"#440154FF","polyline":["rq|eFyizsZSPy@r@ONOTo@fAW`@GJsAvBW^WZWZYVjDqh@XkET_DNoB^wFRgDF_A{BWqAOsEi@qIcAiAKkAQy@GcBS}BYH_@Jc@Na@N]P]P]T[TWfA_BlCsCn@s@l@m@NKPEHCNANCB?JCN?N?L?N?NB~@NhBPn@FpBXdAJxAPx@FxBXh@FbBTD@rANXDdCZlAL^DfBT^DhAP~@J|BXH@bD`@`AJjBT~ARb@FnC\\tBVPB~BXN?nBVr@LvEh@tANxD^f@D^DxDZjHp@bDX]fFOjCk@rImBf@u@RiBd@cFrAwBj@o@PsD`AaFnA{@VcB`@cAVcAZiAZo@Lw@Tq@PcBd@mAX_AXmBd@q@Rs@Rw@PyBj@eAXu@Rq@PiBf@eBd@}DbA[HSFYPu@^q@\\WJOHMJkA`A"]}]'

	## sf
	set_token("abc")
	m <- mapdeck()

	sf <- spatialwidget::widget_melbourne[ spatialwidget::widget_melbourne$SA2_NAME == "South Yarra - West", ]
	p <- add_polygon(map = m, data = sf)
	expect_equal( as.character( p$x$calls[[1]]$args[[1]] ), geo )

	## TODO( these tests, because some characters are being escaped in the polyline)
	## sfencoded
	# enc <- googlePolylines::encode( sf )
	# p <- add_polygon( map = m, data = enc )
	# expect_equal( as.character( p$x$calls[[1]]$args[[1]] ), poly )
	#
	# ## sfencodedLite
	# enc <- googlePolylines::encode( sf, strip = T )
	# p <- add_polygon( map = m, data = enc )
	# expect_equal( as.character( p$x$calls[[1]]$args[[1]] ), poly )
	#
	# ## data.frame with polyline
	# df <- as.data.frame( enc )
	# df$geometry <- df$geometry
	#
	# p <- add_polygon( map = m, data = df, polyline = "geometry" )
	# expect_equal( as.character( p$x$calls[[1]]$args[[1]] ), poly )

})
