% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest.R
\name{mapbayest}
\alias{mapbayest}
\alias{mbrest}
\title{Estimate parameters (maximum a posteriori)}
\usage{
mapbayest(
  x,
  data = NULL,
  method = "L-BFGS-B",
  hessian = stats::optimHess,
  force_initial_eta = NULL,
  quantile_bound = 0.001,
  control = list(),
  check = TRUE,
  verbose = TRUE,
  progress = TRUE,
  reset = TRUE,
  output = NULL
)

mbrest(...)
}
\arguments{
\item{x}{the model object}

\item{data}{NMTRAN-like data set}

\item{method}{optimization method; possible values are \code{L-BFGS-B} (the default) and \code{newuoa}}

\item{hessian}{function used to compute the Hessian and variance-covariance matrix with (default is \code{stats::optimHess}, alternatively use \code{nlmixr::nlmixrHess})}

\item{force_initial_eta}{a vector of numeric values to start the estimation from (default to 0 for "L-BFGS-B")}

\item{quantile_bound}{a numeric value representing the quantile of the normal distribution admitted to define the bounds for L-BFGS-B (default is 0.001, i.e. 0.1\%)}

\item{control}{a list passed to the optimizer (see \code{\link{optimx}} documentation)}

\item{check}{check model code for mapbayr specification (a logical, default is \code{TRUE})}

\item{verbose}{print a message whenever optimization is reset (a logical, default is \code{TRUE})}

\item{progress}{print a progress bar (a logical, default is \code{TRUE})}

\item{reset}{reset optimizer with new initial eta values if numerical difficulties, or with new bounds (L-BFGS-B) if estimate equal to a bound. (a logical, default is \code{TRUE})}

\item{output}{if \code{NULL} (the default) a mapbayests object is returned; if \code{df} a \emph{mapbay_tab} dataframe is returned}

\item{...}{passed to mapbayest}
}
\value{
a mapbayests object. Basically a list containing:
\itemize{
\item model: the model object
\item arg.ofv.optim, arg.ofv.fix, arg.ofv.id: arguments passed to the optimization function. Useful for debugging but not relevant for a basic usage. Access to the data with \code{get_data(x)}
\item opt.value: the original output of the optimization function
\item final_eta: a list of individual vectors of final estimates. Access it with \code{x$final_eta} or \code{get_eta(x)}.
\item covariance: a list of individual variance-covariance matrix of estimation. Access it with \code{x$covariance} or \code{get_cov(x)}.
\item mapbay_tab: an output table containing the results of your estimations (data, IPRED, PRED, covariates, captured items, ETA etc...). Access it with \code{x$mapbay_tab}, \code{as.data.frame(x)} or \code{as_tibble(x)}.
\item information: run times and package versions.
}
}
\description{
The main function of the mapbayr package. Performs a \emph{maximum a posteriori} Bayesian estimation of parameters, from a mrgsolve model object and a dataset containing information about administrations and observed concentrations.
}
\examples{
# First, code a model
code1 <- "$PARAM ETA1 = 0, ETA2 = 0,
KA = 0.5, TVCL = 1.1, TVV = 23.3
$OMEGA 0.41 0.32
$SIGMA 0.04 0
$CMT DEPOT CENT
$PK
double CL=TVCL*exp(ETA1+ETA(1));
double V=TVV*exp(ETA2+ETA(2)) ;
$ERROR
double DV=CENT/V*(1+EPS(1))+EPS(2);
$PKMODEL ncmt = 1, depot = TRUE
$CAPTURE DV CL
"

my_model <- mrgsolve::mcode("my_model", code1)
# Then, import your data
my_data <- data.frame(ID = 1, TIME = c(0, 1.1, 5.2, 12.3), EVID = c(1,0,0,0), AMT = c(500, 0,0,0),
 CMT = c(1,2,2,2), DV = c(0, 15.1, 29.5, 22.3))
print(my_data)

# And estimate
my_est <- mapbayest(x = my_model, data = my_data)
print(my_est)
# see also plot(my_est) and hist(my_est)

# Use your estimation
get_eta(my_est)
get_param(my_est)
as.data.frame(my_est)
use_posterior(my_est)

}
\seealso{
\code{\link{hist.mapbayests}}

\code{\link{plot.mapbayests}}

\code{\link{use_posterior}}
}
