% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_cache_clear.R
\name{esp_clear_cache}
\alias{esp_clear_cache}
\title{Clear your \pkg{mapSpain} cache dir}
\usage{
esp_clear_cache(config = FALSE, cached_data = TRUE, verbose = FALSE)
}
\arguments{
\item{config}{if \code{TRUE}, will delete the configuration folder of
\pkg{mapSpain}.}

\item{cached_data}{If this is set to \code{TRUE}, it will delete your
\code{cache_dir} and all its content.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
Invisible. This function is called for its side effects.
}
\description{
\strong{Use this function with caution}. This function would clear your cached
data and configuration, specifically:
\itemize{
\item Deletes the \pkg{mapSpain} config directory
(\code{rappdirs::user_config_dir("mapSpain", "R")}).
\item Deletes the \code{cache_dir} directory.
\item Deletes the values on stored on \code{Sys.getenv("MAPSPAIN_CACHE_DIR")} and
\code{options(mapSpain_cache_dir)}.
}
}
\details{
This is an overkill function that is intended to reset your status
as it you would never have installed and/or used \pkg{mapSpain}.
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
esp_clear_cache(verbose = TRUE)
}

Sys.getenv("MAPSPAIN_CACHE_DIR")
}
\seealso{
Other cache utilities: 
\code{\link{esp_set_cache_dir}()}
}
\concept{cache utilities}
