% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_tidy.R
\name{tidy}
\alias{tidy}
\alias{join_nodes}
\alias{join_ties}
\alias{mutate_ties}
\alias{select_ties}
\alias{filter_ties}
\alias{rename_ties}
\alias{summarise_ties}
\alias{bind_node_attributes}
\title{Tidy manipulations of node or tie data}
\usage{
join_nodes(
  .data,
  object2,
  by = NULL,
  join_type = c("full", "left", "right", "inner")
)

join_ties(.data, object2, attr_name)

mutate_ties(.data, ...)

select_ties(.data, ...)

filter_ties(.data, ...)

rename_ties(.data, ...)

summarise_ties(.data, ...)

bind_node_attributes(.data, object2)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{object2}{A second object to copy nodes or edges from.}

\item{by}{An attribute name to join objects by.
By default, NULL.}

\item{join_type}{A type of join to be used.
Options are "full","left", "right", "inner".}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{...}{Additional arguments.}
}
\value{
A tidygraph (\code{tbl_graph}) data object.
}
\description{
These functions allow users to add nodes, ties, or attributes to the nodes or ties
of a network.
The \verb{join_*()}, \verb{mutate_*()}, \verb{select_*()}, \verb{filter_*()}, \verb{rename_*()}, and \verb{summarise_*()}
functions adapt the \code{{dplyr}}-type syntax to work with networks of any type.
}
\section{Functions}{
\itemize{
\item \code{join_nodes()}: Copies node attributes from a given graph into specified graph

\item \code{join_ties()}: Copies ties from another graph to specified graph and
adds a tie attribute identifying the ties that were newly added

\item \code{mutate_ties()}: Tidy way to add vector as tie attributes.

\item \code{select_ties()}: Tidy way to select tie attributes.

\item \code{filter_ties()}: Tidy way to filter ties based on a logical statement with
relation to some tie attribute.

\item \code{rename_ties()}: Tidy way to rename tie attributes.

\item \code{summarise_ties()}: Tidy way to summarise tie attributes.

\item \code{bind_node_attributes()}: Copying all nodal attributes from one network to another

}}
\examples{
  other <- create_filled(4) \%>\% mutate(name = c("A", "B", "C", "D"))
  another <- create_filled(3) \%>\% mutate(name = c("E", "F", "G"))
  join_nodes(another, other)
  mutate_ties(other, form = 1:6) \%>\% filter_ties(form < 4)
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{transform}()}
}
\concept{manipulations}
