% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_serial}
\alias{data_serial}
\title{Sample Dataset: Serial
Mediation}
\format{
A data frame with 100 rows
and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{m1}{Mediator 1. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_serial
}
\description{
A serial mediation
model.
}
\examples{
library(lavaan)
data(data_serial)
mod <-
"
m1 ~ a * x + c1 + c2
m2 ~ b1 * m1 + x + c1 + c2
y ~ b2 * m2 + m1 + x + c1 + c2
indirect := a * b1 * b2
"
fit <- sem(mod, data_serial,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 4, 8, 28), ]
}
\keyword{datasets}
