% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.MAPraster.R
\name{as.MAPraster}
\alias{as.MAPraster}
\title{Convert Raster objects into MAPraster objects}
\usage{
as.MAPraster(raster_object)
}
\arguments{
\item{raster_object}{RasterLayer or Rasterstack object to convert into a MAPraster.}
}
\value{
\code{as.MAPraster} returns a MAPraster object (data.frame) containing the below columns.

\enumerate{
\item \code{x} - x coordinates of raster pixels
\item \code{y} - y coordinates of raster pixels
\item \code{z} - value of raster pixels
\item \code{raster_name} - name of raster for which values are stored in z
}
}
\description{
\code{as.MAPraster} converts a RasterLayer or RasterStack object into a 'MAPraster' object (data.frame) for easy plotting with ggplot.
}
\examples{
# Download PfPR2-10 Raster for Madagascar in 2015 and visualise this on a map.
\dontrun{
MDG_shp <- getShp(ISO = "MDG", admin_level = "admin0")
MDG_PfPR2_10 <- getRaster(surface = "Plasmodium falciparum PR2-10", shp = MDG_shp, year = 2015)
MDG_PfPR2_10 <- as.MAPraster(MDG_PfPR2_10)
autoplot(MDG_PfPR2_10)}

#Download global raster of G6PD deficiency from Howes et al 2012 and visualise this on a map.
\dontrun{
G6PDd_global <- getRaster(surface = "G6PD Deficiency Allele Frequency")
G6PDd_global <- as.MAPraster(G6PDd_global)
autoplot(G6PDd_global)}

}
\seealso{
\code{\link{getRaster}}:

to download rasters directly from MAP.

\code{\link{as.MAPraster}}:

to convert RasterLayer/RasterStack objects into a 'MAPraster' object (data.frame) for easy plotting with ggplot.

\code{\link{autoplot.MAPraster}}:

to quickly visualise MAPraster objects created using \code{as.MAPraster}.
}
