% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVecOcc.R
\name{getVecOcc}
\alias{getVecOcc}
\title{Download Vector Occurrence points from the MAP database
\code{getVecOcc} downloads all publicly available vector occurrence points for a specified country (or countries) and returns this as a dataframe.
\code{country} and \code{ISO} refer to countries and a lower-level administrative regions such as French Guiana.}
\usage{
getVecOcc(
  country = NULL,
  ISO = NULL,
  continent = NULL,
  species = "all",
  extent = NULL
)
}
\arguments{
\item{country}{string containing name of desired country, e.g. \code{ c("Country1", "Country2", ...)} OR \code{ = "ALL"}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{ISO}{string containing ISO3 code for desired country, e.g. \code{c("XXX", "YYY", ...)} OR \code{ = "ALL"}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{continent}{string containing continent (one of "Africa", "Americas", "Asia", "Oceania") for desired data, e.g. \code{c("continent1", "continent2", ...)}. (Use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{species}{string specifying the Anopheles species for which to find vector occurrence points, options include: \code{"Anopheles...."} OR \code{"ALL"}}

\item{extent}{an object specifying spatial extent within which PR data is desired, as returned by sf::st_bbox().}
}
\value{
\code{getVecOcc} returns a dataframe containing the below columns, in which each row represents a distinct data point/ study site.
\enumerate{
\item \code{COLUMNNAME} description of contents
\item \code{COLUMNNAME} description of contents
\item \code{COLUMNNAME} description of contents
}
}
\description{
Download Vector Occurrence points from the MAP database
\code{getVecOcc} downloads all publicly available vector occurrence points for a specified country (or countries) and returns this as a dataframe.
\code{country} and \code{ISO} refer to countries and a lower-level administrative regions such as French Guiana.
}
\examples{
# Download vector occurrence data for Brazil and map the locations using autoplot.vector.points
\donttest{
Brazil_vec <- getVecOcc(country = "Brazil")
autoplot(Brazil_vec)

# Download vector data for Madagascar and map the locations using autoplot
Madagascar_vec <- getVecOcc(ISO = "MDG", species = "All")
autoplot(Madagascar_vec)

# Subset by extent.
extent_vec <- getVecOcc(extent = matrix(c(100,13,110,18), nrow = 2), species = 'all')
}


}
\seealso{
\code{autoplot} method for quick mapping of Vector occurrence point locations (\code{\link{autoplot.vector.points}}).
}
