% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isAvailable.R
\name{isAvailable}
\alias{isAvailable}
\title{Available data to download from the MAP geoserver.}
\usage{
isAvailable(sourcedata = NULL, full_results = FALSE, country = NULL,
  ISO = NULL, continent = NULL)
}
\arguments{
\item{sourcedata}{One of 'pr points' or 'vector points'}

\item{full_results}{Should the list be printed to the console?}

\item{country}{string containing name of desired country, e.g. \code{ c("Country1", "Country2", ...)} OR \code{ = "ALL"} (use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{ISO}{string containing ISO3 code for desired country, e.g. \code{c("XXX", "YYY", ...)} OR \code{ = "ALL"} (use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{continent}{string containing continent for desired data, e.g. \code{c("continent1", "continent2", ...)} (use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}
}
\value{
\code{isAvailable} returns a data.frame detailing the administrative units for which shapefiles are stored on the MAP geoserver.
}
\description{
\code{isAvaiable} is a wrapper for isAvailable_pr and isAvailable_vec, listing data (PR survey point location data and vector occurrence locations available to download from the MAP geoserver.
}
\examples{
\donttest{
available_pr_locations <- isAvailable_pr(ISO = 'IDN')
available_vector_locations <- isAvailable_vec(ISO = 'IDN')
}
}
\seealso{
\code{link{isAvailable_pr}}
\code{\link{isAvailable_vec}}
}
